#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <math.h>

double EL = -60;
double C = 20;
double gL = 2.8;
double v12mp = -40;
double kmp = -6;
double v12hp = -55;
double khp = 10;
double tauhp = 4000;
double gNaP = 5;
double ENa = 50;
double EK=-85;
double Ee=0;
double Ei=-75;

double v12n=-30, kn=-4, gKdr=5, gAD=10, tad=2000;

double gE=10, gI=60;

double a12 = .5;
double b32 = .05;
double b42 = .42;

double b23 = .42;
double b43 = .2;

double b24 = .22;
double b34 = .0;

double a15 = .5;
double b25 = .3;
double b35 = .7;
double b45 = .7;

double taupp=3000;

double taul=500;

inline double ninf(double v) { return 1./(1+exp((v-v12n)/kn)); }
inline double mpinf(double v) { return 1./(1+exp((v-v12mp)/kmp)); }
inline double hpinf(double v) { return 1./(1+exp((v-v12hp)/khp)); }
inline double tauinf(double v) { return tauhp/cosh((v-v12hp)/(khp)); }

double vlow = -50;
double vhigh = -20;

inline double f(double v) { return v<vlow?0:(v>vhigh?1:((v-vlow)/(vhigh-vlow))); }

double d1 = .1;
double d2 = .35;//.5;
double d3 = .4;
double d4 = .32;//.4;
double d5 = .8;

double b41=.1;
double b31=.0;

double hb=.1, hb2=.0;
double hr=.0009;
double rsa4=0;//.0005;
double rsa5=0;//.0005;
double rsal=.0005;
double baro=.05;
double baro2=.0;
double sym=.0;
double db=.00;
double sb=.0;


double sigma=.001;
double sm=.001;


double taup=1000;
double p2=1.2, p1=.8, p0=(p1-p2*exp(-1./hr/taup))/(1-exp(-1./hr/taup));
double sv4=0;//-.3;
double sv5=0;//-.4;
double svl=-.2;

double rvlm=0;

inline double rnd() { return double(rand())/RAND_MAX; }

using namespace std;

void cpg(double t,double *v,double dt)
{
	static double TI=0,TE=0, TH[3]={};

	double& v1=v[0];
	double& v2=v[1];
	double& v3=v[2];
	double& v4=v[3];
	double& v5=v[4];
	double& h=v[5];
	double& m2=v[6];
	double& m3=v[7];
	double& m4=v[8];
	double& l=v[9];
	double& r=v[10];
	double& p=v[11];
	double& pp=v[12];

	double v1p=-gKdr*pow(ninf(v1),4)*(v1-EK)-gL*(v1-EL)-gNaP*mpinf(v1)*h*(v1-ENa);
	double v2p=-gKdr*pow(ninf(v2),4)*(v2-EK)-gL*(v2-EL)-gAD*m2*(v2-EK);
	double v3p=-gKdr*pow(ninf(v3),4)*(v3-EK)-gL*(v3-EL)-gAD*m3*(v3-EK);
	double v4p=-gKdr*pow(ninf(v4),4)*(v4-EK)-gL*(v4-EL)-gAD*m4*(v4-EK);
	double v5p=-gKdr*pow(ninf(v5),4)*(v5-EK)-gL*(v5-EL);
	
	double pth=p1,vth=-45;

	v1p-=gE*(d1)*(v1-Ee)+gI*(b31*f(v3)+b41*f(v4))*(v1-Ei);
	v2p-=gE*(d2+a12*f(v1))*(v2-Ee)+gI*(b32*f(v3)+b42*f(v4)+hb2*l)*(v2-Ei);
	v3p-=gE*(d3)*(v3-Ee)+gI*(b23*f(v2)+b43*f(v4))*(v3-Ei);
	v4p-=gE*(d4+hb*l+baro*((p>pth && v5<vth)?(p-pth):0))*(v4-Ee)+gI*(b24*f(v2)+b34*f(v3))*(v4-Ei);
	v5p-=gE*(d5+a15*f(v1))*(v5-Ee)+gI*(b25*f(v2)+b35*f(v3)+b45*f(v4))*(v5-Ei);

    v1+=v1p/C*dt;
	v2+=v2p/C*dt;
	v3+=v3p/C*dt;
	v4+=v4p/C*dt;
	
	double v5pre=v5;
	v5+=v5p/C*dt;
	if(v5pre>vth && v5<=vth) TI=t;
	if(v5pre<vth && v5>=vth) TE=t;

	h+=(hpinf(v1)-h)/tauinf(v1)*dt;
	m2+=((f(v2)-m2)/tad+0*(rnd()-.5))*dt;
    m3+=(f(v3)-m3)/tad*dt;
	m4+=((f(v4)-m4)/tad*2+sm*(rnd()-.5))*dt;
	l+=(f(v5)-l)/taul*dt;
	double rpre=r;
	r+=(hr+rsa4*f(v4)+rsa5*f(v5)+rsal*l-db*pp+sigma*(rnd()-.5))*dt;
	
	if(rpre<int(r))
	{
		double SV=(p2-p1)*(1+sv4*f(v4)+sv5*f(v5)+svl*l);

		TH[2]=TH[1]; TH[1]=TH[0]; TH[0]=t;

		cerr<<t<<'\t'<<TI<<'\t'<<TE<<'\t'<<(p/(p2-p1))<<'\t'<<((TH[0]+TH[1])/2)<<'\t'<<(TH[0]-TH[1])<<'\t'<<SV<<endl;

		p+=SV;
	}
	p+=(rvlm*(f(v5)+f(v4))-(p-p0))/taup*dt;
	pp+=(p-pp)/taupp*dt;
}

int main()
{
	double T=60000;
	double dt=.1,DT=10;
	double v[13]={-60, -60, -60, -60, -30, .3, 0, 0, 0, 0, 0, 1, 1};
	
	for(double t=0;t<=T;t+=dt)
	{
    	cpg(t,v,dt);
        if(int(t/dt)%int(DT/dt)==0) { cout<<(t/1000); for(int i=0;i<13;i++) cout<<'\t'<<v[i]; cout<<endl; }
	}
	return 0;
}

