/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.BSys;
import JSim.bcl.btex.Chem;
import JSim.mml.Comp;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.StringTokenizer;

class ChemEqn {
    private String eqn;
    protected Chem.List chem;
    protected Chem.List lchem;
    protected Chem.List rchem;
    protected double[] lcoef;
    protected double[] rcoef;

    protected ChemEqn(BSys sys, String e) throws Xcept {
        this.eqn = e;
        StringTokenizer tokz = new StringTokenizer(this.eqn, "+= ", true);
        int ct = tokz.countTokens();
        this.lchem = new Chem.List(ct);
        this.rchem = new Chem.List(ct);
        this.lcoef = new double[ct];
        this.rcoef = new double[ct];
        float coef = -1.0f;
        boolean nPending = false;
        double mult = 0.0;
        for (int i = 0; i < ct; ++i) {
            int j;
            int k;
            String tok = tokz.nextToken();
            if (tok.equals("+") || tok.equals(" ")) continue;
            if (tok.equals("=")) {
                if (coef != -1.0f) {
                    throw new Xcept("Ill-formed Reaction equation");
                }
                coef = 1.0f;
                continue;
            }
            for (k = 0; k < tok.length() && !Character.isLetter(tok.charAt(k)); ++k) {
            }
            if (nPending) {
                if (k > 0) {
                    throw new Xcept("Ill-formed Reaction equation");
                }
                nPending = false;
            } else if (k == 0) {
                mult = 1.0;
            } else {
                mult = Util.toDouble((String)tok.substring(0, k));
                if (k == tok.length()) {
                    nPending = true;
                    continue;
                }
            }
            String chname = tok.substring(k);
            Comp c1 = sys.getChild(chname);
            if (c1 == null || !Chem.class.isInstance((Object)c1)) {
                throw new Xcept("Unknown Chem " + chname);
            }
            if (coef < 0.0f) {
                this.lchem.addUniq((Expr)c1);
                int n = j = this.lchem.indexOf((Object)c1);
                this.lcoef[n] = this.lcoef[n] - (double)coef * mult;
                continue;
            }
            this.rchem.addUniq((Expr)c1);
            int n = j = this.rchem.indexOf((Object)c1);
            this.rcoef[n] = this.rcoef[n] + (double)coef * mult;
        }
        if (coef != 1.0f) {
            throw new Xcept(this.eqn + ": Ill-formed Chemical equation");
        }
        this.chem = new Chem.List(ct);
        this.chem.addUniq(this.lchem);
        this.chem.addUniq(this.rchem);
    }

    public double factor(Chem c, boolean left) {
        Chem.List chem = left ? this.lchem : this.rchem;
        double[] coef = left ? this.lcoef : this.rcoef;
        int j = chem.indexOf((Object)c);
        return j < 0 ? 0.0 : coef[j];
    }

    public double lfactor(Chem c) {
        return this.factor(c, true);
    }

    public double rfactor(Chem c) {
        return this.factor(c, false);
    }

    public double factor(Chem c) {
        return this.rfactor(c) - this.lfactor(c);
    }

    public double rtot() {
        double tot = 0.0;
        for (int i = 0; i < this.rchem.size(); ++i) {
            tot += this.rcoef[i];
        }
        return tot;
    }

    public double ltot() {
        double tot = 0.0;
        for (int i = 0; i < this.lchem.size(); ++i) {
            tot += this.lcoef[i];
        }
        return tot;
    }

    public String diagStr() {
        int i;
        String s = this.eqn + ":";
        for (i = 0; i < this.lchem.size(); ++i) {
            s = s + " " + this.lchem.comp(i).name() + "*" + this.lcoef[i];
        }
        for (i = 0; i < this.rchem.size(); ++i) {
            s = s + " " + this.rchem.comp(i).name() + "*" + this.rcoef[i];
        }
        return s;
    }

    public String toString() {
        return this.eqn;
    }
}

