/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.BComp;
import JSim.bcl.btex.Chem;
import JSim.bcl.btex.Region;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class Production
extends BComp {
    Region region;
    Chem chem;
    RealNVar rate;

    public Production(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.checkNParm(e, 2);
        this.region = (Region)this.getParm(e, 0, Region.class);
        this.chem = (Chem)this.getParm(e, 1, Chem.class);
        this.rate = new RealNVar(this, "rate", this.sys.tlist());
        this.region.attach(this);
    }

    public Expr concDelta(Chem ch) throws Xcept {
        return this.chem == ch ? this.rate : Expr.zero;
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        Unit cunit = this.chem.unit().div(this.region.unit()).div(this.sys.t.unit());
        this.setVarUnit(this.rate, cunit);
    }

    protected void solve2() throws Xcept {
        super.solve2();
        this.setVar(this.rate, (Expr)Expr.zero, false);
    }

    public static class List
    extends Comp.List {
        public List(int n) {
            super(n);
        }

        public Production prod(int n) {
            return (Production)((Object)this.get(n));
        }
    }
}

