/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.Chem;
import JSim.bcl.btex.Flow;
import JSim.bcl.btex.Membrane;
import JSim.bcl.btex.Production;
import JSim.bcl.btex.ReactionSlow;
import JSim.bcl.btex.Region;
import JSim.bcl.btex.Transport;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.ConstExpr;
import JSim.util.Expr;
import JSim.util.Xcept;

public class Region0D
extends Region {
    public Region0D(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
    }

    protected void addChem(Chem c) throws Xcept {
        RealNVar v = new RealNVar(this, c.name() + "conc", this.sys.tlist());
    }

    protected void solve1() throws Xcept {
        super.solve1();
        if (this.inflows.size() != this.outflows.size()) {
            throw new Xcept(this.name() + ": unbalanced region inflow & outflow");
        }
        if (this.inflows.size() > 1) {
            throw new Xcept(this.name() + ": overconnected region inflow & outflow");
        }
        if (this.inflows.size() > 0) {
            Flow inflow = (Flow)this.inflows.comp(0);
            Flow outflow = (Flow)this.outflows.comp(0);
            outflow.setInflow((Expr)inflow.F);
        }
    }

    protected Expr slowDelta(Chem c) throws Xcept {
        Flow flow;
        int j;
        ConstExpr e = Expr.zero;
        for (j = 0; j < this.inflows.size(); ++j) {
            flow = (Flow)this.inflows.comp(j);
            e = e.add(flow.F.div((Expr)this.V).mult((Expr)flow.conc(c)));
        }
        for (j = 0; j < this.outflows.size(); ++j) {
            flow = (Flow)this.outflows.comp(j);
            e = e.sub(flow.F.div((Expr)this.V).mult((Expr)this.conc(c)));
        }
        for (j = 0; j < this.prod.size(); ++j) {
            Production p = this.prod.prod(j);
            e = e.add(p.concDelta(c));
        }
        for (j = 0; j < this.reac.size(); ++j) {
            if (this.reac.reac(j).isFast()) continue;
            ReactionSlow r = (ReactionSlow)this.reac.reac(j);
            e = e.add(r.concDelta(c));
        }
        for (j = 0; j < this.mem.size(); ++j) {
            Membrane m = (Membrane)this.mem.comp(j);
            for (int k = 0; k < m.transp.size(); ++k) {
                Transport tr = (Transport)m.transp.comp(k);
                e = e.add(tr.concDelta(this, c));
            }
        }
        return e.simplify();
    }
}

