/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.Chem;
import JSim.bcl.btex.Membrane;
import JSim.bcl.btex.Region;
import JSim.bcl.btex.Transport;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class TransportFlux
extends Transport {
    protected Chem c;
    protected RealNVar flux;

    public TransportFlux(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.checkNParm(e, 2);
        this.mem = (Membrane)this.getParm(e, 0, Membrane.class);
        this.c = (Chem)this.getParm(e, 1, Chem.class);
        this.mem.attach(this);
        this.flux = new RealNVar(this, "flux", this.sys.tlist());
    }

    public Expr concDelta(Region r, Chem ch) throws Xcept {
        if (ch != this.c) {
            return Expr.zero;
        }
        Expr pflux = this.flux.div((Expr)r.V);
        if (r == this.mem.region1) {
            return Expr.negone.mult(pflux);
        }
        if (r == this.mem.region2) {
            return pflux;
        }
        return Expr.zero;
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        Unit cunit = this.c.unit().div(this.sys.t.unit());
        this.setVarUnit(this.flux, cunit);
    }
}

