/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.Chem;
import JSim.bcl.btex.Membrane;
import JSim.bcl.btex.Region;
import JSim.bcl.btex.Transport;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class TransportPS
extends Transport {
    protected Chem c;
    protected RealNVar PS;

    public TransportPS(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.checkNParm(e, 2);
        this.mem = (Membrane)this.getParm(e, 0, Membrane.class);
        this.c = (Chem)this.getParm(e, 1, Chem.class);
        this.mem.attach(this);
        this.PS = new RealNVar(this, "PS", this.sys.tlist());
    }

    public Expr concDelta(Region r, Chem ch) throws Xcept {
        Region r2;
        Region r1;
        if (ch != this.c) {
            return Expr.zero;
        }
        if (r == this.mem.region1) {
            r1 = this.mem.region1;
            r2 = this.mem.region2;
        } else if (r == this.mem.region2) {
            r1 = this.mem.region2;
            r2 = this.mem.region1;
        } else {
            throw new Xcept((DiagInfo)this, "Cannot get regionDelta of " + r.name());
        }
        return this.PS.div((Expr)r.V).mult(r2.conc(this.c).sub((Expr)r1.conc(this.c)));
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        Unit cunit = this.mem.region1.unit().div(this.sys.t.unit());
        this.setVarUnit(this.PS, cunit);
    }
}

