/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.MFSys;
import JSim.mml.Comp;
import JSim.mml.Eqn;
import JSim.mml.Model;
import JSim.mml.RealNVar;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;

abstract class MFComp
extends Comp {
    protected MFSys sys;
    protected Unit unit;

    public MFComp(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        if (this.parent == null) {
            this.sys = new MFSys(null, n + ".systemplate", null);
            this.parent = this.sys;
            return;
        }
        try {
            this.sys = (MFSys)this.parent;
        }
        catch (ClassCastException e1) {
            throw new Xcept((DiagInfo)this.parent, this.name + " parent must be MFAX.MFSys");
        }
    }

    protected void addChem(Chem c) throws Xcept {
    }

    protected void solve1() throws Xcept {
    }

    protected void solve2() throws Xcept {
    }

    protected Unit timeUnit() {
        return this.sys.t.unit();
    }

    protected RealNVar conc(Chem c) throws Xcept {
        RealNVar v = (RealNVar)this.getChild(c.name());
        if (v == null) {
            throw new Xcept((DiagInfo)this, "Internal concentration variable not found: " + c.name());
        }
        return v;
    }

    protected RealNVar addConc(Chem c) throws Xcept {
        RealNVar v = new RealNVar(this, c.name(), this.sys.tlist());
        return v;
    }

    protected void checkNParm(Expr.List e, int n) throws Xcept {
        int ct;
        int n2 = ct = e == null ? 0 : e.size();
        if (ct != n) {
            throw new Xcept(((Object)((Object)this)).getClass().getName() + " requires " + n + " arguments");
        }
    }

    protected Comp getParm(Expr.List e, int n, Class clss) throws Xcept {
        Comp c = (Comp)e.expr(n).getNamed();
        if (c == null) {
            throw new Xcept((DiagInfo)this, "Argument #" + (n + 1) + " must be simple component");
        }
        if (!clss.isInstance((Object)c)) {
            throw new Xcept((DiagInfo)this, "Argument #" + (n + 1) + " must be of class " + clss.getName());
        }
        return c;
    }

    protected Expr varExpr(SubDom sd, Var v) throws Xcept {
        Eqn e;
        int i;
        Eqn ematch = null;
        for (i = 0; i < this.sys.eqn.size(); ++i) {
            e = this.sys.eqn.eqn(i);
            if (e.lhs != v || !sd.sameAs(e.sdom())) continue;
            ematch = e;
            break;
        }
        for (i = 0; i < this.eqn.size(); ++i) {
            e = this.eqn.eqn(i);
            if (e.lhs != v || !sd.sameAs(e.sdom())) continue;
            ematch = e;
            break;
        }
        return ematch == null ? null : ematch.rhs;
    }

    protected boolean varSet(SubDom sd, Var v) throws Xcept {
        return this.varExpr(sd, v) != null;
    }

    protected void setVar(Var v, Expr expr, boolean force) throws Xcept {
        this.setVar(SubDom.entire(), v, expr, force);
    }

    protected void setVar(SubDom sd, Var v, Expr expr, boolean force) throws Xcept {
        if (!this.varSet(sd, v)) {
            Eqn eqn = new Eqn(this.sys, sd.expr, (Expr)v, 48, expr.simplify());
            Util.verbose((String)("adding eqn " + eqn));
            return;
        }
        Util.verbose((String)("Variable not set,  was set previously " + (Object)((Object)v)));
        if (force) {
            throw new Xcept((DiagInfo)v, "This variable is not user settable");
        }
    }

    public abstract String compatibleUnit();

    public Unit unit() {
        return this.unit;
    }

    public void setUnit(Unit u) throws Xcept {
        Model model = this.getModel();
        if (model.unitControl == 2) {
            Unit cunit = model.parseUnit(this.compatibleUnit());
            if (!Unit.compatible((Unit)cunit, (Unit)u)) {
                throw new Xcept((DiagInfo)this, "Unit for component " + ((Object)((Object)this)).getClass().getName() + " must be compatible with " + cunit.name());
            }
            this.unit = u;
        }
    }

    public void assignUnits() throws Xcept {
        if (this.unit == null) {
            this.setUnit(Unit.scalar());
        }
    }

    protected void assignConcUnits() throws Xcept {
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            Chem c = this.sys.chem.chem(i);
            this.setVarUnit(this.conc(c), c.unit());
        }
    }

    public void setVarUnit(Var v, Unit u) throws Xcept {
        if (v.unit() == null) {
            v.setUnit(u);
        }
        if (!Unit.compatible((Unit)v.unit(), (Unit)u)) {
            new Xcept((DiagInfo)v, "Unit must be compatible with " + u);
        }
    }
}

