/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.MFComp;
import JSim.bcl.mfax.Region;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Xcept;

public class Production
extends MFComp {
    Region region;
    Chem chem;
    RealNVar flux;

    public Production(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.checkNParm(e, 2);
        this.region = (Region)this.getParm(e, 0, Region.class);
        this.chem = (Chem)this.getParm(e, 1, Chem.class);
        this.flux = new RealNVar(this, "flux", this.sys.tlist());
        this.region.attach(this);
    }

    public Expr concDelta(Chem ch) throws Xcept {
        return this.chem == ch ? this.flux.div((Expr)this.region.vol) : Expr.zero;
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        this.setVarUnit(this.flux, this.chem.fluxUnit());
    }

    protected void solve2() throws Xcept {
        super.solve2();
        this.setVar(this.flux, (Expr)Expr.zero, false);
    }

    public static class List
    extends Comp.List {
        public List(int n) {
            super(n);
        }

        public Production prod(int n) {
            return (Production)((Object)this.get(n));
        }
    }
}

