/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.Membrane;
import JSim.bcl.mfax.Region;
import JSim.bcl.mfax.Transport;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Xcept;

public class TransportFlux
extends Transport {
    protected Chem c;
    protected RealNVar flux;

    public TransportFlux(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.checkNParm(e, 2);
        this.mem = (Membrane)this.getParm(e, 0, Membrane.class);
        this.c = (Chem)this.getParm(e, 1, Chem.class);
        this.mem.attach(this);
        this.flux = new RealNVar(this, "flux", this.sys.tlist());
    }

    public Expr concDelta(Region r, Chem ch) throws Xcept {
        if (ch != this.c) {
            return Expr.zero;
        }
        Expr pflux = this.flux.div((Expr)r.vol);
        if (r == this.mem.region1) {
            return Expr.negone.mult(pflux);
        }
        if (r == this.mem.region2) {
            return pflux;
        }
        return Expr.zero;
    }

    public String compatibleUnit() {
        return "dimensionless";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        this.setVarUnit(this.flux, this.c.fluxUnit());
    }
}

