/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.xsim;

import JSim.bcl.xsim.Ivar;
import JSim.bcl.xsim.XSLib;
import JSim.bcl.xsim.XSVar;
import JSim.mml.Comp;
import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.Sys;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.UtilIO;
import JSim.util.Xcept;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;

public class XSSys
extends Sys {
    protected XSLib lib;
    protected Ivar t;
    private Expr.List tlist;

    public XSSys(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
    }

    public Expr.List tlist() throws Xcept {
        if (this.tlist == null) {
            this.tlist = new Expr.List(1);
            this.tlist.add((Object)this.t);
        }
        return this.tlist;
    }

    public void writeFlat(PrintStream out, Context ctxt) throws Xcept {
        int i;
        this.expandChildDerivs();
        int maxloc = 0;
        Var.List vsin = new Var.List(32);
        Var.List vsout = new Var.List(32);
        Var.List vdin = new Var.List(32);
        Var.List vdout = new Var.List(32);
        vsin.add((Object)this.t.vmin);
        vsin.add((Object)this.t.vmax);
        vsin.add((Object)this.t.vdelta);
        for (int i2 = 0; i2 < this.child.size(); ++i2) {
            if (!(this.child.comp(i2) instanceof Var)) continue;
            Var v = (Var)this.child.comp(i2);
            Var.List list = null;
            if (v instanceof XSVar.RealInput || v instanceof XSVar.IntInput || v instanceof XSVar.ChoiceInput || v instanceof Ivar) {
                list = v.hasDomain(this.t) ? vdin : vsin;
            } else if (v instanceof XSVar.RealOutput) {
                Var.List list2 = list = v.hasDomain(this.t) ? vdout : vsout;
            }
            if (list == null) continue;
            int loc = this.loc(v);
            if (loc > maxloc) {
                maxloc = loc;
            }
            list.add((Object)v);
        }
        Var.List vinit = new Var.List(32);
        vinit.addAll((Collection)((Object)vdin));
        vinit.addAll((Collection)((Object)vsin));
        out.println("");
        out.println("source procedure xsinit(" + this.fargList(vinit) + "; xsInitFlag) {");
        out.println("\tlanguage = \"java\";");
        out.println("\tmaincode={{");
        out.println("\t    xsmodel.setModel(model);");
        for (i = 0; i < vinit.size(); ++i) {
            out.println("\t    " + this.setPCode(vinit.var(i)));
        }
        out.println("\t    xsmodel.init();");
        out.println("\t    xsInitFlag.set(1);");
        out.println("\t}};");
        out.println("\tbottomcode={{");
        out.println("\t    } // drop out of JSxsinit__class");
        out.println("\t    public static RTXSimModel xsmodel;");
        out.println("\t    static { xsmodel = new JSX" + this.lib.libName() + "(); }");
        out.println("\t    public void xsinitDummy() { // absorb dangling right brace");
        out.println("\t}};");
        out.println("}");
        out.println("");
        out.println("source procedure xsloop(xsInitFlag, " + this.fargList(vdin) + "; xsLoopFlag, " + this.fargList(vdout) + ") {");
        out.println("\tlanguage = \"java\";");
        out.println("\tmaincode={{");
        for (i = 0; i < vdin.size(); ++i) {
            out.println("\t    " + this.setPCode(vdin.var(i)));
        }
        out.println("\t    xsmodel.loop();");
        out.println("\t    xsLoopFlag.set(1);");
        for (i = 0; i < vdout.size(); ++i) {
            out.println("\t    " + this.getPCode(vdout.var(i)));
        }
        out.println("\t}};");
        out.println("}");
        out.println("");
        out.print("source procedure xscomp(xsLoopFlag; xsCompFlag");
        if (vsout.size() > 0) {
            out.print("," + this.fargList(vsout));
        }
        out.println(") {");
        out.println("\tlanguage = \"java\";");
        out.println("\tmaincode={{");
        out.println("\t    xsmodel.comp();");
        out.println("\t    xsCompFlag.set(1);");
        for (i = 0; i < vsout.size(); ++i) {
            out.println("\t    " + this.getPCode(vsout.var(i)));
        }
        out.println("\t}};");
        out.println("}");
        out.println("");
        out.println("math " + this.name() + " {");
        super.writeFlat(out, ctxt);
        out.println("");
        out.println("\tprivate real xsInitFlag, xsLoopFlag(" + this.t.name() + "), xsCompFlag;");
        out.println("\twhen (" + this.t.name() + "=" + this.t.name() + ".min) xsinit(" + this.fcallList(vinit) + ", xsInitFlag);");
        out.println("\txsloop(xsInitFlag, " + this.fcallList(vdin) + ", xsLoopFlag, " + this.fcallList(vdout) + ");");
        out.print("\txscomp(xsLoopFlag(" + this.t.name() + ".max), xsCompFlag");
        if (vsout.size() > 0) {
            out.print("," + this.fcallList(vsout));
        }
        out.println(");");
        out.println("}");
        String res = "JSXWrapJ.txt";
        URL url = ((Object)((Object)this)).getClass().getResource(res);
        if (url == null) {
            throw new Xcept((DiagInfo)this, "XSim wrapper resource \"" + res + "\" not found");
        }
        String txt = UtilIO.readText((URL)url);
        txt = txt.replaceAll("proto", this.lib.libName());
        out.println("extern java {{");
        out.println(txt);
        out.println("}};");
    }

    private String setPCode(Var v) throws Xcept {
        Domain x = this.xdomain(v);
        if (x == null) {
            return "xsmodel.setP(" + (this.loc(v) - 1) + ", " + this.fargName(v) + ".realVal());";
        }
        return "xsmodel.setP(" + (this.loc(v) - 1) + ", Math.min(" + this.fargName(v) + ".nsamples()," + this.maxDim(v) + "), " + this.locincr(v) + ", " + this.fargName(v) + ".samples());";
    }

    private String getPCode(Var v) throws Xcept {
        Domain x = this.xdomain(v);
        if (x == null) {
            return this.fargName(v) + ".set(xsmodel.getP(" + (this.loc(v) - 1) + "));";
        }
        return this.fargName(v) + ".setSome(" + "xsmodel.getP(" + (this.loc(v) - 1) + ", Math.min(" + this.fargName(v) + ".nsamples()," + this.maxDim(v) + "), " + this.locincr(v) + "));";
    }

    private String fargName(Var v) {
        return "xs" + v.toString().replace('.', '_');
    }

    private String fargAtName(Var v) throws Xcept {
        String n = this.fargName(v);
        Domain x = this.xdomain(v);
        if (x != null) {
            n = n + "@" + this.fargName(x);
        }
        return n;
    }

    private String fargList(Var.List vlist) throws Xcept {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < vlist.size(); ++i) {
            if (i > 0) {
                s.append(",");
            }
            if (i > 0 && i % 6 == 0) {
                s.append("\n");
            }
            s.append(this.fargAtName(vlist.var(i)));
        }
        return s.toString();
    }

    private String fcallList(Var.List vlist) throws Xcept {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < vlist.size(); ++i) {
            if (i > 0) {
                s.append(",");
            }
            if (i > 0 && i % 6 == 0) {
                s.append("\n");
            }
            Var v = vlist.var(i);
            s.append(v.toString());
            Domain x = this.xdomain(v);
            if (x == null) continue;
            s.append("@" + x.toString());
        }
        return s.toString();
    }

    protected Domain xdomain(Var v) throws Xcept {
        Domain x = null;
        for (int i = 0; i < v.ndim(); ++i) {
            if (v.domain(i) == this.t) continue;
            if (x != null) {
                throw new Xcept((DiagInfo)v, "Too many domains for XSim variable");
            }
            x = v.domain(i);
        }
        return x;
    }

    private int locincr(Var v) throws Xcept {
        return this.intVal(v, "locincr", 1);
    }

    private int maxDim(Var v) throws Xcept {
        return this.intVal(v, "dim", 0);
    }

    private int loc(Var v) throws Xcept {
        if (v.getParent() == this.t) {
            if (v == this.t.vmin) {
                return this.loc(this.t) - 2;
            }
            if (v == this.t.vmax) {
                return this.loc(this.t) - 1;
            }
            if (v == this.t.vdelta) {
                return this.loc(this.t) + 1;
            }
        }
        return this.intVal(v, "loc", 0);
    }

    private int intVal(Var v, String p, int def) throws Xcept {
        CompProp prop = v.prop(p);
        if (prop == null) {
            throw new Xcept((DiagInfo)v, "no such property <" + p + ">");
        }
        if (prop.isSet()) {
            return (int)prop.constRealVal();
        }
        if (def != 0) {
            return def;
        }
        throw new Xcept((DiagInfo)prop, "property not defined");
    }
}

