/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLEqn;
import JSim.cellml.CMLReac;
import JSim.cellml.CMLVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class CMLReacRole
implements DiagInfo {
    protected CMLReac reac;
    private CMLVar var;
    private CMLVar deltaVar;
    private double stoich;
    protected String roleName;
    protected CMLEqn.List eqns;

    protected CMLReacRole(CMLReac r, CMLVar v, Element elem) throws Xcept {
        this.reac = r;
        this.var = v;
        this.eqns = new CMLEqn.List();
        this.roleName = elem.getAttribute("role");
        String s = elem.getAttribute("stoichiometry");
        this.stoich = Util.isBlank((String)s) ? Double.NaN : Util.toDouble((String)s);
        s = elem.getAttribute("delta_variable");
        if (!Util.isBlank((String)s)) {
            this.deltaVar = this.reac.comp.var(s);
            if (this.deltaVar == null) {
                throw new Xcept((DiagInfo)this, "Undefined delta_variable=" + s);
            }
        }
    }

    protected void addMath() throws Xcept {
        if (!this.roleName.equals("product") && !this.roleName.equals("reactant")) {
            return;
        }
        if (this.deltaVar == null) {
            return;
        }
        if (Double.isNaN(this.stoich) && this.eqns.size() == 0) {
            throw new Xcept((DiagInfo)this, "Products/reactants must define either math or stoichiometry.");
        }
        if (!Double.isNaN(this.stoich) && this.eqns.size() > 0) {
            throw new Xcept((DiagInfo)this, "Products/reactants may not define both math and stoichiometry.");
        }
        if (this.eqns.size() > 0) {
            return;
        }
        if (this.reac.rate == null || this.reac.rate.var == null) {
            throw new Xcept((DiagInfo)this, "Reaction rate not declared.");
        }
        int sign = this.roleName.equals("reactant") ? 1 : -1;
        Expr rhs = Expr.cons((double)((double)sign * this.stoich)).mult((Expr)this.reac.rate.var);
        CMLEqn e = new CMLEqn(this.reac.comp, this.deltaVar.eq(rhs));
        this.eqns.add(e);
    }

    protected void writeMML(PrintWriter out) throws Xcept {
        if (this.eqns.size() == 0) {
            return;
        }
        out.println("\t// <reaction> variable=\"" + (Object)((Object)this.var) + "\" role=\"" + this.roleName + "\"");
        for (int i = 0; i < this.eqns.size(); ++i) {
            this.eqns.eqn(i).writeMML(out);
        }
    }

    public String diagInfo() {
        return this.var.name() + " role=" + this.roleName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLReacRole> {
        public List(int n) {
            super(n);
        }

        public CMLReacRole role(int i) {
            return (CMLReacRole)this.get(i);
        }
    }
}

