/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLComp;
import JSim.cellml.CMLVarGroup;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.NamedList;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class CMLVar
extends NamedExpr {
    protected CMLComp comp;
    protected List connectVars;
    protected CMLVarGroup varGroup;
    private String name;
    protected boolean isDomain;
    protected boolean isInput;
    protected String initVal;
    protected Unit unit;
    protected boolean hasDeriv;
    protected Expr.List domains;

    protected CMLVar(CMLComp c, Element elem) throws Xcept {
        String kpri;
        this.comp = c;
        this.connectVars = new List(4);
        this.name = elem.getAttribute("name");
        Util.verbose((String)("  processing variable " + this.name));
        String kpub = elem.getAttribute("public_interface");
        if (Util.isBlank((String)kpub)) {
            kpub = "none";
        }
        if (Util.isBlank((String)(kpri = elem.getAttribute("private_interface")))) {
            kpri = "none";
        }
        this.isInput = kpub.equals("in") || kpri.equals("in");
        String uname = elem.getAttribute("units");
        this.unit = this.comp.doc.getUnit(uname);
        this.initVal = elem.getAttribute("initial_value");
        this.domains = new Expr.List(2);
    }

    public Expr takeDomDeriv(NamedExpr x) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDomDeriv() not implemented");
    }

    public Expr expandDeriv() throws Xcept {
        return this;
    }

    public Expr unitCorrect() {
        return this;
    }

    public Unit unit() {
        return this.unit;
    }

    public Expr calculable(Known known) {
        return Expr.truex;
    }

    public void addDomains(Expr.List exprs) {
    }

    public String toString(Context ctxt) {
        return this.toString();
    }

    public String toString() {
        return this.mmlName();
    }

    public boolean sameAs(Expr expr) {
        return this == expr;
    }

    public int dataType() {
        return 4;
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        String cname = this.comp.name();
        return cname + "." + this.name;
    }

    public String mmlName() {
        if (this.varGroup == null) {
            return this.fullName();
        }
        return this.varGroup.mmlName;
    }

    public String diagInfo() {
        return "CellML variable " + this.fullName();
    }

    public static class NList
    extends NamedList {
        public NList() {
            super(16);
        }

        public CMLVar var(int i) {
            return (CMLVar)((Object)this.get(i));
        }

        public CMLVar var(String n) {
            return (CMLVar)((Object)this.getByName(n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLVar> {
        public List(int n) {
            super(n);
        }

        public CMLVar var(int i) {
            return (CMLVar)((Object)this.get(i));
        }
    }
}

