/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.jcode.JPlanWriter;
import JSim.jcode.JSubWriter;
import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan.Cache;
import JSim.plan.Calc;
import JSim.plan.DomainCalc;
import JSim.plan.ExprCalc;
import JSim.plan.FuncCalc;
import JSim.plan.IfCalc;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.ProcCalc;
import JSim.plan.RelationCalc;
import JSim.plan.SetCalc;
import JSim.util.Context;
import JSim.util.Xcept;

public class JCalcWriter
extends JSubWriter {
    public Calc.List parallelCalcs = new Calc.List();
    private int loopCt;

    public JCalcWriter(JPlanWriter w) {
        super(w);
    }

    public void write(ExprCalc calc) throws Xcept {
        String vcache = this.ctxt.vcache(calc.v);
        String vstruct = this.ctxt.vstruct(calc.v);
        String sexpr = calc.expr.toString((Context)this.ctxt);
        int action = 0;
        if (this.wrt.buildInfo.options.boolVal("traceNaN", false)) {
            action += 2;
        }
        if (this.wrt.traceVars != null && this.wrt.traceVars.contains((Object)calc.v.name())) {
            ++action;
        }
        if (this.wrt.buildInfo.options.boolVal("abortNaN", false)) {
            action += 4;
        }
        if (this.cache().v0.contains((Object)calc.v)) {
            if (!calc.v.sameAs(calc.expr)) {
                this.println(vcache + " = " + sexpr + ";");
            }
            if (action > 0) {
                this.println("trace(" + action + ", " + vstruct + ", " + vcache + ");");
            }
            if (calc.recalc()) {
                this.println("set(" + vstruct + ", " + vcache + ");");
            }
        } else {
            String set = "set(";
            if (action > 0) {
                set = "setTrace(" + action + ", ";
            }
            this.println(set + vstruct + ", " + sexpr + ");");
        }
    }

    public void write(DomainCalc calc) throws Xcept {
        this.println(this.ctxt.vstruct(calc.x) + ".setGridRegular(this);");
    }

    public void write(FuncCalc calc) throws Xcept {
        this.println(this.ctxt.funcCallName(calc.funcCall) + ".voidVal(this);");
    }

    public void write(SetCalc calc) throws Xcept {
        if (calc.calc.size() == 0) {
            return;
        }
        String s = calc.isLHBC() ? "LHBC" : "RHBC";
        this.println("set" + s + "(" + this.ctxt.vstruct(calc.x) + ");");
        this.indentIn();
        this.write(calc.calc);
        this.indentOut();
    }

    public void write(LoopCalc calc) throws Xcept {
        boolean p;
        boolean topLevel;
        ++this.loopCt;
        boolean bl = topLevel = calc.phase > 0;
        if (topLevel) {
            this.println("startPhase(" + calc.phase + ", " + this.ctxt.vstruct(calc.x) + ");");
        }
        if (p = calc.isParallel()) {
            int n = this.parallelCalcs.size();
            this.parallelCalcs.add(calc);
            this.println("calcGroup(" + n + "); // loop over " + calc.x.name());
        } else {
            this.println("for (setLHBC(" + this.ctxt.vstruct(calc.x) + "); " + "isSet(" + this.ctxt.vstruct(calc.x) + "); " + "moveRight(" + this.ctxt.vstruct(calc.x) + ")) {" + " //loop#=" + this.loopCt);
            this.indentIn();
            Cache cache = this.wrt.plan.cache();
            if (cache.v0.contains((Object)calc.x)) {
                this.println(this.ctxt.vcache(calc.x) + " = realVal(" + this.ctxt.vstruct(calc.x) + ");");
            }
            this.writeCalc(calc.loop);
            if (topLevel) {
                this.println("updatePhase((inx(" + this.ctxt.vstruct(calc.x) + ")+1.0)/" + "ct(" + this.ctxt.vstruct(calc.x) + "));");
            }
            this.writeInterruptCheck();
            this.indentOut();
            this.println("}");
        }
        if (topLevel) {
            this.println("startPhase(" + (calc.phase + 1) + ", null);");
        }
    }

    public void write(IfCalc calc) throws Xcept {
        this.println("if (" + calc.test.toString((Context)this.ctxt) + ") {");
        if (calc.pass != null) {
            this.indentIn();
            this.writeCalc(calc.pass);
            this.indentOut();
        }
        if (calc.fail != null) {
            this.println("} else {");
            this.indentIn();
            this.writeCalc(calc.pass);
            this.indentOut();
        }
        this.println("}");
    }

    public void write(MultiCalc calc) throws Xcept {
        for (int i = 0; i < calc.calc.size(); ++i) {
            Calc c = calc.calc.get(i);
            this.writeCalc(c);
        }
    }

    public void write(ProcCalc calc) throws Xcept {
        this.println(calc.proc.name + ".solve(this);");
    }

    public void write(RelationCalc calc) throws Xcept {
        this.println("if (!(" + calc.expr.toString((Context)this.ctxt) + ")) badRelation(\"" + calc.expr.toString() + "\");");
    }

    public void writeCalcGroups() throws Xcept {
        Calc calc;
        int i;
        if (this.parallelCalcs.size() < 1) {
            return;
        }
        this.println("public void calcGroupInit(RTContext ctxt, int gcode) throws Xcept {");
        this.indentIn();
        this.println("super.calcGroupInit(ctxt, gcode);");
        this.println("XContext xctxt = (XContext) ctxt;");
        for (i = 0; i < this.cache().v0.size(); ++i) {
            Var v = this.cache().v0.var(i);
            String vc = this.ctxt.vcache(v);
            this.println(vc + " = xctxt." + vc + ";");
        }
        this.indentOut();
        this.println("}");
        this.println("");
        for (i = 0; i < this.parallelCalcs.size(); ++i) {
            calc = this.parallelCalcs.calc(i);
            if (!(calc instanceof LoopCalc)) continue;
            LoopCalc lcalc = (LoopCalc)calc;
            this.println("public void calcGroup_" + i + "(int fromX, int toX) throws Xcept {");
            this.indentIn();
            this.println("for (int i=fromX; i<toX; i++) {");
            this.indentIn();
            this.println("setInx(" + this.ctxt.vstruct(lcalc.x) + ", i);");
            this.write(lcalc.loop);
            this.writeInterruptCheck();
            this.println("}");
            this.indentOut();
            this.println("}");
            this.println("");
            this.indentOut();
        }
        this.println("public int calcGroupSize(int gcode) throws Xcept {");
        this.indentIn();
        this.println("switch (gcode) {");
        for (i = 0; i < this.parallelCalcs.size(); ++i) {
            calc = this.parallelCalcs.calc(i);
            if (!(calc instanceof LoopCalc)) continue;
            Domain x = ((LoopCalc)calc).x;
            this.println("case " + i + ": return intVal(" + this.ctxt.vstruct(x.vct) + ");");
        }
        this.println("default: return super.calcGroupSize(gcode);");
        this.println("}");
        this.indentOut();
        this.println("}");
        this.println("");
        this.println("public void calcGroup(int gcode, int fromX, int toX) throws Xcept {");
        this.indentIn();
        this.println("switch (gcode) {");
        for (i = 0; i < this.parallelCalcs.size(); ++i) {
            this.println("case " + i + ": calcGroup_" + i + "(fromX, toX); break;");
        }
        this.println("default: super.calcGroup(gcode, fromX, toX); break;");
        this.println("}");
        this.indentOut();
        this.println("}");
        this.println("");
    }
}

