/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.jcode.JLang;
import JSim.jcode.JPlanWriter;
import JSim.mml.CompContext;
import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.UnitCast;
import JSim.util.XFuncCall;
import JSim.util.Xcept;

public class JContext
extends CompContext {
    public JPlanWriter wrt;
    public CompContext jctxt;
    public Domain muStepDomain;

    public JContext(JPlanWriter w) {
        super(JLang.lang, w.math);
        this.wrt = w;
        this.jctxt = new CompContext(JLang.lang, this.wrt.math);
        this.muStepDomain = null;
    }

    public String toString(double value) {
        if (Double.isNaN(value)) {
            return "Double.NaN";
        }
        return super.toString(value);
    }

    public String newName(Named n) {
        Var v = (Var)n;
        if (this.wrt.cache != null && this.wrt.cache.v0.contains((Object)v)) {
            return this.vcache(v);
        }
        if (v.hasDomain(this.muStepDomain)) {
            return this.vmuStep(v);
        }
        return "realVal(" + this.vstruct(v) + ")";
    }

    public String vcache(Var v) {
        return "js" + this.jctxt.newName((Named)v);
    }

    public String vstruct(Var v) {
        return "JS" + this.jctxt.newName((Named)v);
    }

    public String vmuStep(Var v) {
        StringBuffer buf = new StringBuffer("realVal(" + this.vstruct(v) + ", new double[] {");
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x;
            if (i > 0) {
                buf.append(",");
            }
            if ((x = v.domain(i)) == this.muStepDomain) {
                buf.append(this.vcache(x));
                continue;
            }
            buf.append("realVal(" + this.vstruct(x) + ")");
        }
        buf.append("})");
        return buf.toString();
    }

    public String funcCallName(XFuncCall fc) {
        return "JS" + fc.func().name() + "__" + fc.seq();
    }

    public String funcCall(Named n, Expr.List elist) {
        if (n instanceof Var) {
            String s = "realVal(" + this.vstruct((Var)n) + ", new double[] {";
            for (int i = 0; i < elist.size(); ++i) {
                if (i > 0) {
                    s = s + ",";
                }
                s = s + elist.expr(i).toString((Context)this);
            }
            return s + "})";
        }
        XFuncCall fc = (XFuncCall)n;
        return this.funcCallName(fc) + ".realVal(this)";
    }

    public String unitCast(UnitCast cast) {
        Expr expr = cast.expr();
        if (cast.factor() != 1.0) {
            try {
                expr = expr.mult((Expr)Expr.cons((double)cast.factor()));
            }
            catch (Xcept e) {
                System.err.println("Illegal unit cast toString");
            }
        }
        return expr.toString((Context)this);
    }
}

