/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JPlanWriter;
import JSim.jcode2.JWriter;
import JSim.mml.IntegralIF;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.RealConst;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.LinkedHashSet;

public class JExprWriter
extends JWriter {
    protected JExprWriter parent;
    protected LinkedHashSet<Var> cache;
    protected int cacheLevel;
    protected boolean isMu;

    public JExprWriter(JExprWriter parent) {
        this.parent = parent;
        this.cache = new LinkedHashSet();
        if (parent != null) {
            this.cacheLevel = parent.cacheLevel + 1;
            this.isMu = parent.isMu;
        }
    }

    public JPlanWriter planWriter() {
        return this.parent.planWriter();
    }

    public JWriter.State state() {
        return this.planWriter().state();
    }

    public String vcache(Var v) {
        if (this.cache.contains((Object)v)) {
            return this.vcache(v, this.cacheLevel);
        }
        return this.parentVcache(v);
    }

    public String parentVcache(Var v) {
        if (this.parent != null) {
            return this.parent.vcache(v);
        }
        return null;
    }

    public boolean isMuCached(Var v) {
        if (this.cache.contains((Object)v)) {
            return this.isMu;
        }
        if (this.parent != null) {
            return this.parent.isMuCached(v);
        }
        return false;
    }

    public String fmt(Expr expr) throws Xcept {
        if (expr instanceof Var) {
            return this.fmt1((Var)expr);
        }
        if (expr instanceof IExpr) {
            return this.fmt1((IExpr)expr);
        }
        if (expr instanceof RealConst) {
            return this.fmt1((RealConst)expr);
        }
        if (expr instanceof VarFuncCall) {
            return this.fmt1((VarFuncCall)expr);
        }
        if (expr instanceof XFuncCall) {
            return this.fmt1((XFuncCall)expr);
        }
        if (expr instanceof IntegralIF) {
            return this.fmt1((IntegralIF)expr);
        }
        if (expr == null) {
            throw new Xcept("JExprWriter null expr");
        }
        throw new Xcept("JExprWriter doesn't support " + expr + " class=" + expr.getClass());
    }

    private String fmt1(Var v) {
        String s = this.vcache(v);
        return s == null ? this.vcurr(v) : s;
    }

    private String fmt1(IExpr expr) throws Xcept {
        int op = expr.op();
        String sop = this.jlang.chars(op);
        int n = expr.nargs();
        String[] sargs = new String[n];
        for (int i = 0; i < n; ++i) {
            sargs[i] = this.fmt(expr.arg(i));
        }
        if (this.jlang.swapXY(op)) {
            String stemp = sargs[0];
            sargs[0] = sargs[1];
            sargs[1] = stemp;
        }
        if (this.jlang.func(op)) {
            return this.fmt(sop, sargs);
        }
        if (n == 1) {
            return sop + "(" + sargs[0] + ")";
        }
        if (n == 2) {
            return "(" + sargs[0] + sop + sargs[1] + ")";
        }
        if (op == 66) {
            return "((" + sargs[0] + ") ? (" + sargs[1] + ") : (" + sargs[2] + "))";
        }
        throw new Xcept("JWriter: no format for operator=" + op);
    }

    private String fmt1(RealConst c) {
        double d = c.realVal(null);
        if (Double.isNaN(d)) {
            return "Double.NaN";
        }
        String s = c.toString();
        if (d < 0.0) {
            s = "(" + s + ")";
        }
        return s;
    }

    private String fmt1(VarFuncCall vfc) throws Xcept {
        String buf = "realVal(" + this.vstruct(vfc.v) + ", new double[] {";
        for (int i = 0; i < vfc.args.size(); ++i) {
            if (i > 0) {
                buf = buf + ",";
            }
            buf = buf + this.fmt(vfc.args.expr(i));
        }
        return buf + "})";
    }

    private String fmt1(XFuncCall fc) throws Xcept {
        return this.planWriter().fpWriter.funcCallName(fc) + ".realVal(this)";
    }

    private String fmt1(IntegralIF integ) throws Xcept {
        return this.fmt(integ.evalExpr());
    }
}

