/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JExprWriter;
import JSim.jcode2.JPlanWriter;
import JSim.mml.ClassFunc;
import JSim.mml.CommonFunc;
import JSim.mml.Model;
import JSim.mml.SourceFunc;
import JSim.mml.Var;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.StringList;
import JSim.util.XFunc;
import JSim.util.XFuncArg;
import JSim.util.XFuncCall;
import JSim.util.Xcept;

public class JFPWriter
extends JExprWriter {
    private JPlanWriter planWriter;
    private XFunc.NList funcs;

    public JFPWriter(JPlanWriter planWriter) throws Xcept {
        super(null);
        this.planWriter = planWriter;
        this.funcs = this.flatModel().neededFuncs();
    }

    public void setSourceLibs() throws Xcept {
        String libName;
        String funcName = libName = "JSfunc1001";
        for (int i = 0; i < this.funcs().size(); ++i) {
            SourceFunc f;
            if (!(this.funcs().xfunc(i) instanceof SourceFunc) || (f = (SourceFunc)this.funcs().xfunc(i)).libName() != null) continue;
            f.setLibrary(libName, funcName);
        }
    }

    public void writeDecl() throws Xcept {
        int i;
        this.println("// F&P declarations");
        for (i = 0; i < this.funcs().size(); ++i) {
            XFunc f = this.funcs().xfunc(i);
            this.println("public RTXFunc " + this.funcName(f) + ";");
        }
        for (i = 0; i < this.funcCalls().size(); ++i) {
            XFuncCall fc = (XFuncCall)this.funcCalls().expr(i);
            this.println("public RTXFuncCall " + this.funcCallName(fc) + ";");
        }
        this.println("");
    }

    public void writeInit() throws Xcept {
        int i;
        this.println("// F&P initialization");
        for (i = 0; i < this.funcs().size(); ++i) {
            XFunc f = this.funcs().xfunc(i);
            if (f instanceof ClassFunc) {
                this.writeFunc((ClassFunc)f);
                continue;
            }
            if (f instanceof CommonFunc) {
                this.writeFunc((CommonFunc)f);
                continue;
            }
            throw new Xcept((DiagInfo)f, "JPlanWriter does not support this XFunc type");
        }
        for (i = 0; i < this.funcCalls().size(); ++i) {
            XFuncCall fc = (XFuncCall)this.funcCalls().expr(i);
            this.println(this.funcCallName(fc) + " = new RTXFuncCall(" + this.funcName(fc.func()) + ");");
            for (int j = 0; j < fc.args().size(); ++j) {
                this.writeFuncArg(fc, fc.args().arg(j), j);
            }
        }
        this.println("");
    }

    public void writeMethods() throws Xcept {
        this.println("// ctxt methods for F&P");
        for (int i = 0; i < this.funcCalls().size(); ++i) {
            XFuncCall fc = (XFuncCall)this.funcCalls().expr(i);
            for (int j = 0; j < fc.args().size(); ++j) {
                XFuncArg arg = fc.args().arg(j);
                this.println("protected double " + this.funcCallName(fc) + "_" + j + "_getRealVal() throws Xcept {");
                this.indentIn();
                this.println("return " + this.fmt(arg.base()) + ";");
                this.indentOut();
                this.println("}");
            }
        }
    }

    public void writeFunc(ClassFunc f) throws Xcept {
        this.println(this.funcName(f) + " = new " + f.className() + "(this, \"" + f.name() + "\");");
    }

    public void writeFunc(CommonFunc f) throws Xcept {
        if (f.libName() != null) {
            String className = this.nativeClassName(f.libName());
            this.println(this.funcName(f) + " = new " + className + "(this, \"" + f.name() + "\", " + className + "." + this.nativeFuncInx(f) + ");");
        } else {
            this.println(this.funcName(f) + " = new " + this.funcClassName(f) + "(this, \"" + f.name() + "\");");
        }
    }

    public String domStr(Expr.List doms) {
        String s = "new RTRealDomain[] {";
        for (int i = 0; i < doms.size(); ++i) {
            if (i != 0) {
                s = s + ",";
            }
            Var v = (Var)((Object)doms.get(i));
            s = s + this.vstruct(v);
        }
        return s + "}";
    }

    public void writeFuncArg(XFuncCall fc, XFuncArg arg, int argInx) throws Xcept {
        Expr base = arg.base();
        if (base instanceof Var) {
            Var v = (Var)base;
            this.println("new RTXFuncArg(" + this.funcCallName(fc) + ", " + this.domStr(arg.argDoms()) + ", " + this.vstruct(v) + ", " + arg.isInput() + ");");
            return;
        }
        String n = this.funcCallName(fc);
        this.println("new RTXFuncArg(" + n + ", " + this.domStr(arg.argDoms()) + ") {");
        this.indentIn();
        this.println("protected double getRealVal(RTContext ctxt) throws Xcept {");
        this.indentIn();
        this.println("return ((XContext) ctxt)." + n + "_" + argInx + "_getRealVal();");
        this.indentOut();
        this.println("}");
        this.indentOut();
        this.println("};");
    }

    public void writeJavaClasses() throws Xcept {
        for (int i = 0; i < this.funcs().size(); ++i) {
            XFunc f = this.funcs().xfunc(i);
            if (!(f instanceof SourceFunc) || f.lang() != 4) continue;
            this.writeJavaClass((SourceFunc)f);
        }
    }

    public void writeJavaClass(SourceFunc f) throws Xcept {
        this.println("// " + this.funcClassName(f) + " definition");
        this.println("public static class " + this.funcClassName(f) + " extends RTXFunc {");
        this.indentIn();
        if (f.topCode() != null) {
            this.println("// copy topcode here");
            this.println(f.topCode());
            this.println("");
        }
        this.println("public " + this.funcClassName(f) + "(RTModel m, String n) throws Xcept " + "{ super(m, n); }");
        String rtype = f.dataType() == 4 ? "double" : "void";
        String fname = f.dataType() == 4 ? "real" : "void";
        this.println("public " + rtype + " " + fname + "Calculate(RealNData[] jsargs) throws Xcept {");
        this.indentIn();
        for (int i = 0; i < f.nargs(); ++i) {
            this.println("RealNData " + f.parName(i) + " = jsargs[" + i + "];");
        }
        if (f.mainCode() != null) {
            this.println("// copy maincode here");
            this.println(f.mainCode());
            this.println("");
        }
        this.indentOut();
        this.println("}");
        if (f.bottomCode() != null) {
            this.println("// copy bottomcode here");
            this.println(f.bottomCode());
            this.println("");
        }
        this.indentOut();
        this.println("}");
        this.println("");
    }

    public void writeNativeFuncClasses() throws Xcept {
        StringList libs = new StringList(this.funcs().size());
        for (int i = 0; i < this.funcs().size(); ++i) {
            String lib;
            XFunc f1 = this.funcs().xfunc(i);
            if (f1.libName() == null || libs.containSame(lib = f1.libName())) continue;
            libs.add((Object)lib);
            XFunc.NList funcs = new XFunc.NList(this.funcs().size());
            funcs.add((Named)f1);
            for (int j = i + 1; j < this.funcs().size(); ++j) {
                f1 = this.funcs().xfunc(j);
                if (f1.libName() == null || !f1.libName().equals(lib)) continue;
                funcs.add((Named)f1);
            }
            this.writeNativeClass(lib, funcs);
        }
    }

    public void writeNativeClass(String lib, XFunc.NList funcs) throws Xcept {
        CommonFunc f;
        int i;
        this.println("// " + this.nativeClassName(lib) + " definition");
        this.println("class " + this.nativeClassName(lib) + " extends RTXFunc {");
        this.indentIn();
        this.println("int which;");
        this.println("public " + this.nativeClassName(lib) + "(RTModel m, String n, int w) throws Xcept " + "{ super(m, n); which = w; }");
        this.println("public void voidCalculate(RealNData[] args) throws Xcept {");
        this.indentIn();
        this.println("switch (which) {");
        for (i = 0; i < funcs.size(); ++i) {
            f = (CommonFunc)funcs.xfunc(i);
            if (f.dataType() == 4) continue;
            this.println("case " + this.nativeFuncInx(f) + ": " + "JS" + f.funcName() + "(args); break;");
        }
        this.println("default: throw new Xcept(this, \"Unknown native switch value\");");
        this.println("}");
        this.indentOut();
        this.println("}");
        this.println("public double realCalculate(RealNData[] args) throws Xcept {");
        this.indentIn();
        this.println("switch (which) {");
        for (i = 0; i < funcs.size(); ++i) {
            f = (CommonFunc)funcs.xfunc(i);
            if (f.dataType() != 4) continue;
            this.println("case " + this.nativeFuncInx(f) + ": " + "return JS" + f.funcName() + "(args);");
        }
        this.println("default: throw new Xcept(this, \"Unknown native switch value\");");
        this.println("}");
        this.indentOut();
        this.println("}");
        for (i = 0; i < funcs.size(); ++i) {
            f = funcs.xfunc(i);
            this.println("private static native double JS" + f.funcName() + "(RealNData[] args) throws Xcept;");
            this.println("public static final int " + this.nativeFuncInx(f) + " = " + (i + 1) + ";");
        }
        this.println("static { System.loadLibrary(\"" + lib + "\"); }");
        this.indentOut();
        this.println("}");
        this.println("");
    }

    protected void writeCall(XFuncCall fc) throws Xcept {
        this.println(this.funcCallName(fc) + ".voidVal(this);");
    }

    protected void writeExternJava() throws Xcept {
        for (int i = 0; i < this.flatModel().externJava.size(); ++i) {
            this.println("// extern java\n");
            this.println(this.flatModel().externJava.str(i));
        }
    }

    private String funcName(XFunc func) {
        return "JS" + func.name();
    }

    private String funcClassName(XFunc func) {
        return "JS" + func.name() + "__class";
    }

    private String nativeClassName(String lib) {
        return "JSJS" + lib;
    }

    private String nativeFuncInx(XFunc f) {
        return "JSX__" + f.funcName();
    }

    protected String funcCallName(XFuncCall fc) {
        return "JS" + fc.func().name() + "__" + fc.seq();
    }

    public JPlanWriter planWriter() {
        return this.planWriter;
    }

    private Model flatModel() throws Xcept {
        return this.planWriter.mmlModel().getFlatModel();
    }

    private XFunc.NList funcs() {
        return this.funcs;
    }

    private Expr.List funcCalls() throws Xcept {
        return this.flatModel().funcCalls();
    }
}

