/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JMainWriter;
import JSim.jcode2.JMethodWriter;
import JSim.jcode2.JProblemWriter;
import JSim.mml.Var;
import JSim.plan2.ImplicitBound;
import JSim.plan2.ImplicitTool;
import JSim.plan2.TExpr;
import JSim.plan2.VarUsage;
import JSim.util.Xcept;

public class JImplicitWriter
extends JProblemWriter {
    protected ImplicitTool tool;

    public JImplicitWriter(JMethodWriter parent, ImplicitTool tool, String idSfx) throws Xcept {
        super(parent, tool);
        this.tool = tool;
        this.id = parent instanceof JMainWriter ? "" : parent.id + idSfx + "__";
        this.id = this.id + this.vname(tool.vsols.get(0).v());
        for (int i = 0; i < this.n(); ++i) {
            this.cache.add(this.vsol(i).v());
        }
    }

    public void writeClass() throws Xcept {
        this.println("// Implicit block solving " + this.tool.vsols);
        this.println("public class " + this.problemClass() + " extends " + this.extendsClass() + " {");
        this.indentIn();
        this.println("public " + this.problemClass() + "(RTModel m) throws Xcept {");
        this.indentIn();
        this.println("super(m, \"" + this.problemClass() + "\"" + "," + this.n() + ");");
        this.indentOut();
        this.println("}");
        if (this.isLinear()) {
            this.writeCtxtCall("setCoef", "mat,vec,rec", "double[],double[],double[]");
        }
        this.writeCtxtCall("setBounds", "vmin,vmax,vguess", "double[],double[],double[]");
        this.writeCtxtCall("calcZero", "val,zero", "double[],double[]");
        this.writeCtxtCall("export", "val", "double[]");
        this.indentOut();
        this.println("}");
        this.println(" ");
    }

    public void writeMethods() throws Xcept {
        int i;
        this.println("// ctxt methods for " + this.problemClass());
        if (this.isLinear()) {
            this.writeSetCoef();
        }
        this.startMethod("setBounds__" + this.id, "vmin,vmax,vguess", "double[],double[],double[]");
        for (i = 0; i < this.n(); ++i) {
            VarUsage vu = this.vsol(i);
            this.writeBound(vu, -1, "vmin[" + i);
            this.writeBound(vu, 0, "vguess[" + i);
            this.writeBound(vu, 1, "vmax[" + i);
        }
        this.stopMethod();
        this.startMethod("calcZero__" + this.id, "vals,zeroes", "double[],double[]");
        for (i = 0; i < this.n(); ++i) {
            Var v = this.vsol(i).v();
            this.println(this.vcache(v) + "=vals[" + i + "];");
        }
        for (i = 0; i < this.tool.vsols.size(); ++i) {
            TExpr expr = this.tool.exprs.get(i).zeroExpr();
            this.println("zeroes[" + i + "]=" + this.fmt(expr.expr().simplify()) + ";");
        }
        this.stopMethod();
        this.startMethod("export__" + this.id, "vals", "double[]");
        for (i = 0; i < this.n(); ++i) {
            String sexpr = "vals[" + i + "]";
            Var v = this.vsol(i).v();
            String vcache = this.parentVcache(v);
            if (vcache != null) {
                sexpr = vcache + "=" + sexpr;
            }
            if (!this.isMu) {
                sexpr = "set(" + this.vstruct(v) + "," + sexpr + ")";
            }
            if (this.isMu && vcache == null) {
                sexpr = "// " + (Object)((Object)v) + " not exported: mu-stepped & unused by parent";
            }
            this.println(sexpr + ";");
        }
        this.stopMethod();
    }

    public void writeBound(VarUsage vu, int type, String vname) throws Xcept {
        ImplicitBound b = this.tool.getBound(vu, type);
        if (b == null) {
            return;
        }
        String sexpr = this.fmt(b.expr().expr());
        this.println(vname + "]=" + sexpr + ";");
    }

    public void writeSetCoef() throws Xcept {
        int i;
        this.startMethod("setCoef__" + this.id, "mat,vec,rec", "double[],double[],double[]");
        for (i = 0; i < this.n(); ++i) {
            for (int j = 0; j < this.n(); ++j) {
                int k = i * this.n() + j;
                this.println("mat[" + k + "]=" + this.fmt(this.tool.linmat(i, j).expr()) + ";");
            }
        }
        for (i = 0; i < this.n(); ++i) {
            this.println("vec[" + i + "]=" + this.fmt(this.tool.linmat(i, this.n()).expr()) + ";");
        }
        this.stopMethod();
    }

    public boolean isLinear() {
        return this.tool.isLinear();
    }

    public int n() {
        return this.tool.vsols.size();
    }

    public VarUsage vsol(int i) {
        return this.tool.vsols.get(i);
    }

    public String extendsClass() {
        return this.isLinear() ? "Fzero1Problem" : "Fzero2Problem";
    }
}

