/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JMethodWriter;
import JSim.mml.Domain;
import JSim.plan2.SeqBlock;
import JSim.util.Xcept;

public class JLoopWriter
extends JMethodWriter {
    protected SeqBlock.Loop block;
    protected Integer phase;

    public JLoopWriter(JMethodWriter parent, SeqBlock.Loop block, int loopInx) throws Xcept {
        super(parent, block);
        this.block = block;
        this.id = "" + loopInx + this.xname();
        if (parent.id != null) {
            this.id = parent.id + "__" + this.id;
        }
        this.addSubWriterBlock(block);
        this.phase = this.planWriter().loopPhases.get(block);
    }

    public void writeLoopsCall() throws Xcept {
        String sv = this.vstruct(this.x());
        if (this.phase != null) {
            this.println("startPhase(" + this.phase + ", " + sv + ");");
        }
        this.println("for (setLHBC(" + sv + "); isSet(" + sv + "); moveRight(" + sv + ")) " + this.methodName() + "();");
        if (this.phase != null) {
            this.println("startPhase(" + (this.phase + 1) + ", null);");
        }
    }

    public void writeMethods() throws Xcept {
        this.println("// ctxt loop iteration for domain " + (Object)((Object)this.x()));
        this.startMethod(this.methodName(), "", "");
        this.writeBlock(this.block);
        if (this.phase != null) {
            String sv = this.vstruct(this.x());
            this.println("updatePhase((inx(" + sv + ")+1.0)/ct(" + sv + "));");
        }
        this.stopMethod();
        this.println("");
    }

    public Domain x() {
        return this.block.x();
    }

    public String xname() {
        return this.vname(this.x());
    }

    public String methodName() {
        return "loop__" + this.id;
    }
}

