/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JExprWriter;
import JSim.jcode2.JImplicitWriter;
import JSim.jcode2.JLoopWriter;
import JSim.jcode2.JODEWriter;
import JSim.jcode2.JPDEWriter;
import JSim.jcode2.JProblemWriter;
import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.DETool;
import JSim.plan2.DomainTool;
import JSim.plan2.ExprTool;
import JSim.plan2.ExternTool;
import JSim.plan2.ImplicitBound;
import JSim.plan2.ImplicitTool;
import JSim.plan2.MainBlock;
import JSim.plan2.ODEBlock;
import JSim.plan2.PDEBlock;
import JSim.plan2.ProcTool;
import JSim.plan2.QueryTool;
import JSim.plan2.ReuseTool;
import JSim.plan2.SeqBlock;
import JSim.plan2.SeqItem;
import JSim.plan2.StateTool;
import JSim.plan2.TEvent;
import JSim.plan2.TExpr;
import JSim.plan2.TRelation;
import JSim.plan2.TSubDom;
import JSim.plan2.VarUsage;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;

public abstract class JMethodWriter
extends JExprWriter {
    protected String id;
    protected SeqItem item;
    protected ArrayList<JMethodWriter> subWriters;

    public JMethodWriter(JMethodWriter parent, SeqItem item) throws Xcept {
        super(parent);
        this.item = item;
        this.subWriters = new ArrayList();
    }

    public void addSubWriterBlock(SeqBlock block) throws Xcept {
        this.addSubWriterBlock(block, "");
    }

    public void addSubWriterBlock(SeqBlock block, String idSfx) throws Xcept {
        for (int i = 0; i < block.size(); ++i) {
            this.addSubWriter(block.items().get(i), idSfx);
        }
    }

    public void addSubWriter(SeqItem item, String idSfx) throws Xcept {
        JMethodWriter wsub = this.makeSubWriter(item, idSfx);
        if (wsub != null) {
            this.subWriters.add(wsub);
        } else if (item instanceof SeqBlock) {
            this.addSubWriterBlock((SeqBlock)item, idSfx);
        }
    }

    public JMethodWriter makeSubWriter(SeqItem item, String idSfx) throws Xcept {
        if (item instanceof ODEBlock) {
            return new JODEWriter(this, (ODEBlock)item);
        }
        if (item instanceof PDEBlock) {
            return new JPDEWriter(this, (PDEBlock)item);
        }
        if (item instanceof ImplicitTool) {
            return new JImplicitWriter(this, (ImplicitTool)item, idSfx);
        }
        if (item instanceof SeqBlock.Loop) {
            return new JLoopWriter(this, (SeqBlock.Loop)item, this.nloopWriters());
        }
        return null;
    }

    private int nloopWriters() {
        int n = 0;
        for (int i = 0; i < this.subWriters.size(); ++i) {
            if (!(this.subWriters.get(i) instanceof JLoopWriter)) continue;
            ++n;
        }
        return n;
    }

    public JMethodWriter getSubWriter(SeqItem item) {
        for (int i = 0; i < this.subWriters.size(); ++i) {
            JMethodWriter s;
            JMethodWriter swrt = this.subWriters.get(i);
            if (swrt.item == item) {
                return swrt;
            }
            if (!(swrt instanceof JLoopWriter) || (s = swrt.getSubWriter(item)) == null) continue;
            return s;
        }
        return null;
    }

    public abstract void writeMethods() throws Xcept;

    public void writeBlock(SeqBlock block) throws Xcept {
        for (int i = 0; i < block.items().size(); ++i) {
            this.writeItem(block.items().get(i));
        }
        if (!(block instanceof MainBlock) && !(block instanceof ODEBlock)) {
            this.writeInterruptCheck();
        }
    }

    public void writeItem(SeqItem item) throws Xcept {
        if (item instanceof SeqBlock.Loop) {
            this.write((SeqBlock.Loop)item);
        } else if (item instanceof ODEBlock) {
            this.writeSolverCall(item);
        } else if (item instanceof PDEBlock) {
            this.writeSolverCall(item);
        } else if (item instanceof ImplicitTool) {
            this.write((ImplicitTool)item);
        } else if (item instanceof ImplicitBound) {
            this.write((ImplicitBound)item);
        } else if (item instanceof TEvent) {
            this.write((TEvent)item);
        } else if (item instanceof TRelation) {
            this.write((TRelation)item);
        } else if (item instanceof DETool) {
            this.write((DETool)item);
        } else if (item instanceof DomainTool) {
            this.write((DomainTool)item);
        } else if (item instanceof ExprTool) {
            this.write((ExprTool)item);
        } else if (item instanceof ExternTool) {
            this.write((ExternTool)item);
        } else if (item instanceof ProcTool) {
            this.write((ProcTool)item);
        } else if (item instanceof QueryTool) {
            this.write((QueryTool)item);
        } else if (item instanceof ReuseTool) {
            this.write((ReuseTool)item);
        } else if (item instanceof StateTool) {
            this.write((StateTool)item);
        } else {
            if (item == null) {
                throw new Xcept("JBlockWriter: null SeqItem");
            }
            throw new Xcept("Unsupported SeqItem class " + item.getClass());
        }
    }

    protected void write(SeqBlock.Loop block) throws Xcept {
        JLoopWriter wrt = (JLoopWriter)this.getSubWriter(block);
        if (wrt == null) {
            throw new Xcept("Missing subwriter for " + block);
        }
        wrt.writeLoopsCall();
    }

    protected void writeSolverCall(SeqItem item) throws Xcept {
        JProblemWriter wrt = (JProblemWriter)this.getSubWriter(item);
        if (wrt == null) {
            throw new Xcept("Missing subwriter for " + item);
        }
        wrt.writeSolverCall();
    }

    protected void write(ImplicitTool tool) throws Xcept {
        for (int i = 0; i < tool.exprs().size(); ++i) {
            TSubDom sd = tool.exprs().get(i).subdom();
            this.writeWhen(sd);
        }
        JProblemWriter wrt = (JProblemWriter)this.getSubWriter(tool);
        if (wrt == null) {
            throw new Xcept("MethodWriter: " + this.getClass() + " missing subwriter for " + tool.getClass());
        }
        wrt.writeSolverCall();
    }

    protected void write(DETool item) throws Xcept {
        throw new Xcept("JMethodWriter: DETools don't below here");
    }

    protected void write(DomainTool tool) throws Xcept {
        Domain x = tool.x();
        Expr mexpr = x.vmin.add(x.vdelta.mult(x.vct.sub((Expr)Expr.one)));
        this.writeAssign(x.vmax, mexpr);
        this.println(this.vstruct(x) + ".setGridRegular(this);");
    }

    protected void write(ExprTool tool) throws Xcept {
        Var v = tool.v();
        String vcache = this.vcache(v);
        if (this.planWriter().isInput(v) && vcache != null) {
            this.println(vcache + " = " + this.vcurr(v) + ";");
            return;
        }
        TSubDom subdom = tool.expr.subdom();
        VarUsage vu = tool.vu;
        if (!subdom.isEntire()) {
            this.writeWhen(subdom);
        } else if (vu.isBoundary()) {
            this.writeWhen(vu.domain(), vu.isMin());
        }
        this.writeAssign(v, tool.expr.expr());
    }

    protected void writeWhen(TSubDom sd) throws Xcept {
        if (!sd.isEntire()) {
            this.writeWhen(sd.domain(), sd.isLH());
        }
    }

    protected void writeWhen(Domain x, boolean isLH) throws Xcept {
        String sset = isLH ? "setLHBC" : "setRHBC";
        this.println(sset + "(" + this.vstruct(x) + ");");
    }

    protected void writeAssign(Var v, Expr expr) throws Xcept {
        String sexpr = this.fmt(expr);
        String vcache = this.vcache(v);
        if (vcache != null) {
            sexpr = vcache + " = " + sexpr;
        }
        if (!this.isMu) {
            sexpr = "set(" + this.vstruct(v) + "," + sexpr + ")";
        }
        this.println(sexpr + ";");
        this.writeTrace(v);
    }

    protected void writeTrace(Var v) throws Xcept {
        boolean dotrace;
        boolean bl = dotrace = this.planWriter().traceVar(v) || this.planWriter().checkNaN();
        if (!dotrace) {
            return;
        }
        Domain t = null;
        if (this instanceof JODEWriter) {
            t = ((JODEWriter)this).block.t();
        }
        if (this instanceof JPDEWriter) {
            t = ((JPDEWriter)this).block.t();
        }
        String muargs = "null";
        if (t != null) {
            muargs = "\"" + (Object)((Object)t) + "=" + "\"" + "+Util.pretty(" + this.vcache(t) + ")";
        }
        String strace = "trace(" + this.vstruct(v) + "," + this.fmt((Expr)v) + "," + muargs + ");";
        if (this.planWriter().traceVar(v)) {
            this.println(strace);
        } else {
            this.println("if (Double.isNaN(" + this.fmt((Expr)v) + ")) " + strace);
        }
    }

    protected void write(ExternTool tool) throws Xcept {
        if (!this.isMu) {
            this.println("//debug only:  " + tool);
            return;
        }
        Var v = tool.v;
        String line = this.vcache(v) + "=realVal(" + this.vstruct(v) + ", new double[] {";
        for (int i = 0; i < v.ndim(); ++i) {
            if (i > 0) {
                line = line + ",";
            }
            line = line + this.vcache(v.domain(i));
        }
        line = line + "});";
        this.println(line);
    }

    protected void write(ProcTool tool) throws Xcept {
        this.writeWhen(tool.sdom());
        this.planWriter().fpWriter.writeCall(tool.fc());
    }

    protected void write(QueryTool item) throws Xcept {
        this.println("//debug:  " + item);
    }

    protected void write(ReuseTool tool) throws Xcept {
        this.writeWhen(tool.x, true);
        this.writeItem(tool.tool);
    }

    protected void write(StateTool tool) throws Xcept {
        Var v = tool.v;
        Domain t = tool.t;
        String sexpr = "setFromLeft(" + this.vstruct(v) + "," + this.vstruct(t) + ");";
        String vcache = this.vcache(v);
        if (vcache != null) {
            sexpr = vcache + "=" + sexpr;
        }
        this.println("if (! atLHBC(" + this.vstruct(t) + ")) " + sexpr);
    }

    protected void write(ImplicitBound bound) throws Xcept {
        this.write(bound.relation());
    }

    protected void write(TEvent event) throws Xcept {
        String strig = this.fmt(event.trigger.expr());
        this.println("if (" + strig + ") {");
        this.indentIn();
        for (int i = 0; i < event.actions.size(); ++i) {
            TEvent.TAction act = event.actions.get(i);
            this.writeAssign(act.v, act.vexpr.expr());
        }
        this.indentOut();
        this.println("}");
    }

    protected void write(TRelation trel) throws Xcept {
        if (trel.op() == 54) {
            this.println("//debug only: " + trel);
            return;
        }
        TExpr expr = trel.expr();
        TSubDom subdom = expr.subdom();
        this.writeWhen(subdom);
        String sexpr = this.fmt(expr.expr());
        this.println("if (!(" + sexpr + ")) badRelation(" + "\"" + expr.expr() + "\"" + ");");
    }

    protected void writeInterruptCheck() throws Xcept {
        this.println("interruptCheck();");
    }
}

