/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JMethodWriter;
import JSim.jcode2.JProblemWriter;
import JSim.mml.Var;
import JSim.plan2.DETool;
import JSim.plan2.ODEBlock;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;

public class JODEWriter
extends JProblemWriter {
    protected ODEBlock block;
    protected ArrayList<Var> vodes;

    public JODEWriter(JMethodWriter parent, ODEBlock block) throws Xcept {
        super(parent, block);
        this.block = block;
        this.id = "" + this.vname(block.vstate().get(0));
        this.isMu = true;
        this.cache.addAll(block.vmus().vset());
        this.vodes = new ArrayList();
        for (int i = 0; i < block.detools().size(); ++i) {
            DETool detool = block.detools().get(i);
            Var v = detool.v;
            for (int j = 0; j < detool.torder; ++j) {
                this.vodes.add(v);
                v = v.deriv(detool.t);
            }
        }
        this.addSubWriterBlock(block);
    }

    public void writeClass() throws Xcept {
        this.println("// ODE problem solving " + this.block.vstate());
        this.println("public class " + this.problemClass() + " extends " + this.extendsClass() + " {");
        this.indentIn();
        this.println("public " + this.problemClass() + "(RTModel m) throws Xcept {");
        this.indentIn();
        this.println("super(m, \"" + this.problemClass() + "\"" + ");");
        String line = "setup(" + this.vstruct(this.block.t()) + ", new RTRealNVar[] {";
        for (int i = 0; i < this.vodes.size(); ++i) {
            if (i > 0) {
                line = line + ",";
            }
            line = line + this.vstruct(this.vodes.get(i));
        }
        line = line + "});";
        this.println(line);
        this.indentOut();
        this.println("}");
        this.println("public void evaluate(RTContext ctxt, double t, double[] u, double[] udot) throws Xcept {");
        this.indentIn();
        this.println("((XContext) ctxt)." + this.evalMethod() + "(t, u, udot);");
        this.println("interruptCheck(t, udot);");
        this.indentOut();
        this.println("}");
        this.println("public void export(RTContext ctxt) throws Xcept {}");
        this.indentOut();
        this.println("}");
        this.println(" ");
    }

    public void writeMethods() throws Xcept {
        this.println("// ctxt ODE evaluate");
        this.startMethod(this.evalMethod(), "t,u,udot", "double,double[],double[]");
        this.println(this.vcache(this.block.t()) + " = t;");
        for (int i = 0; i < this.vodes.size(); ++i) {
            Var v = this.vodes.get(i);
            this.println(this.vcache(v) + " = u[" + i + "];");
        }
        this.writeBlock(this.block);
        int j = 0;
        for (int i = 0; i < this.block.detools().size(); ++i) {
            DETool detool = this.block.detools().get(i);
            Var v = detool.v.deriv(this.block.t());
            this.println("udot[" + j++ + "] = " + this.fmt((Expr)v) + ";");
            for (int k = 1; k < detool.torder; ++k) {
                v = v.deriv(this.block.t());
                this.println("udot[" + j++ + "] = " + this.fmt((Expr)v) + ";");
            }
        }
        this.stopMethod();
        this.println("");
    }

    public String evalMethod() {
        return "evaluate__" + this.id;
    }

    public String extendsClass() {
        return "ODE1Problem";
    }
}

