/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JMethodWriter;
import JSim.jcode2.JProblemWriter;
import JSim.mml.Domain;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.plan2.BCBlock;
import JSim.plan2.PDE1Factors;
import JSim.plan2.PDEBlock;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDEWriter
extends JProblemWriter {
    protected PDEBlock block;
    protected int n;
    protected Domain t;
    protected Domain x;
    protected ArrayList<Var> us;
    protected ArrayList<Var> uts;
    protected ArrayList<Var> uxs;
    protected ArrayList<Var> uxts;
    protected ArrayList<Var> uxxs;
    protected static final int LSFEA = 0;
    protected static final int MacCormack = 1;
    protected static final int Toms731 = 2;

    public JPDEWriter(JMethodWriter parent, PDEBlock block) throws Xcept {
        super(parent, block);
        this.block = block;
        this.id = "" + this.vname(block.vstate().get(0));
        this.isMu = true;
        if (block.nsolvers() == 0) {
            throw new Xcept("No PDE solvers available for " + block);
        }
        this.n = this.vstate().size();
        this.t = block.t();
        this.x = block.xs().first();
        this.us = this.vstate();
        this.uts = new ArrayList();
        this.uxs = new ArrayList();
        this.uxts = new ArrayList();
        this.uxxs = new ArrayList();
        for (int i = 0; i < this.n; ++i) {
            this.uts.add(this.us.get(i).deriv(this.t));
            this.uxs.add(this.us.get(i).deriv(this.x));
            this.uxts.add(null);
            this.uxxs.add(this.uxs.get(i).deriv(this.x));
        }
        this.cache.addAll(this.uxs);
        this.cache.addAll(block.vmus().vset());
        this.cache.addAll(this.lhbcBlock().vmus().vset());
        this.cache.addAll(this.rhbcBlock().vmus().vset());
        this.addSubWriterBlock(block);
        this.addSubWriterBlock(this.lhbcBlock(), "__LHBC");
        this.addSubWriterBlock(this.rhbcBlock(), "__RHBC");
    }

    @Override
    public void writeClass() throws Xcept {
        this.println("// PDE problem solving " + this.block.vstate());
        this.println("public class " + this.problemClass() + " extends " + this.extendsClass() + " {");
        this.indentIn();
        this.println("public " + this.problemClass() + "(RTModel m) throws Xcept {");
        this.indentIn();
        this.println("super(m, \"" + this.problemClass() + "\"" + ");");
        this.println("setup(" + this.vstruct(this.t) + "," + this.vstruct(this.x) + ",0,");
        this.indentIn();
        this.println(this.fmtArr(this.us) + ",");
        this.println(this.fmtArr(this.uxts) + ",");
        this.println(this.fmtArr(this.uxts) + ",");
        this.println(this.fmtArr(this.uxts) + ",");
        this.println(this.fmtArr(this.uxts) + ",");
        this.println("null, null);");
        this.indentOut();
        this.println("setSolvedVars(new ASVar[] {" + this.vstruct(this.us) + "});");
        this.indentOut();
        this.println("}");
        this.println("public boolean usesPDESolver(int which) {");
        this.indentIn();
        this.println("switch(which) {");
        this.println("case ASModel.PDE_LSFEA: return " + this.doSolver(0) + ";");
        this.println("case ASModel.PDE_MacCormack: return " + this.doSolver(1) + ";");
        this.println("case ASModel.PDE_Toms731: return " + this.doSolver(2) + ";");
        this.println("default: return false;");
        this.println("}");
        this.indentOut();
        this.println("}");
        if (this.doSolver(0) || this.doSolver(1)) {
            this.writeCtxtCall("common_LHB", "t,us,f1s,f2s,f3s", "double,double[],double[],double[],double[]");
            this.writeCtxtCall("common_RHB", "t,us,f1s,f2s,f3s", "double,double[],double[],double[],double[]");
        }
        if (this.doSolver(0)) {
            this.writeCtxtCall("LSFEA_tstep", "t,x,us,uts", "double,double,double[],double[]");
            this.writeCtxtCall("LSFEA_xstep", "t,x,us,uxcoefs,uxxcoefs", "double,double,double[],double[],double[]");
        }
        if (this.doSolver(1)) {
            this.writeCtxtCall("MacCormack_State", "t,x,us,cxs,cxxs,srcs", "double,double,double[],double[],double[],double[]");
        }
        if (this.doSolver(2)) {
            this.writeCtxtCall("Toms731_State", "t,x,us,uxs,cs,qs,rs", "double,double,double[],double[],double[],double[],double[]");
            this.writeCtxtCall("Toms731_LHB", "t,us,uxs,betas,gammas", "double,double[],double[],double[],double[]");
            this.writeCtxtCall("Toms731_RHB", "t,us,uxs,betas,gammas", "double,double[],double[],double[],double[]");
        }
        this.indentOut();
        this.println("}");
        this.println("");
    }

    protected String fmtArr(ArrayList<Var> vs) throws Xcept {
        StringBuffer buf = new StringBuffer("new RTRealNVar[] {");
        for (int i = 0; i < this.n; ++i) {
            Var v;
            if (i > 0) {
                buf.append(",");
            }
            buf.append((v = vs.get(i)) == null ? "null" : this.vstruct(v));
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeMethods() throws Xcept {
        int i;
        this.println("// ctxt methods for " + this.block);
        if (this.doSolver(0)) {
            this.startMethod("LSFEA_tstep__" + this.id, "t,x,us,uts", "double,double,double[],double[]");
            this.loadCacheTU();
            this.writeBlock(this.block);
            for (i = 0; i < this.n; ++i) {
                this.println("uts[" + i + "]=" + this.fmt(this.factors(i).coefS()) + ";");
            }
            this.stopMethod();
            this.startMethod("LSFEA_xstep__" + this.id, "t,x,us,uxcoefs,uxxcoefs", "double,double,double[],double[],double[]");
            this.loadCacheTXU();
            this.writeBlock(this.block);
            for (i = 0; i < this.n; ++i) {
                this.println("uxcoefs[" + i + "]=" + this.fmt(this.factors(i).coefB()) + ";");
                this.println("uxxcoefs[" + i + "]=" + this.fmt(this.factors(i).coefD()) + ";");
            }
            this.stopMethod();
        }
        if (this.doSolver(1)) {
            this.startMethod("MacCormack_State__" + this.id, "t,x,us,cxs,cxxs,srcs", "double,double,double[],double[],double[],double[]");
            this.loadCacheTXU();
            this.writeBlock(this.block);
            for (i = 0; i < this.n; ++i) {
                this.println("cxs[" + i + "]=" + this.fmt(this.factors(i).coefB()) + ";");
                this.println("cxxs[" + i + "]=" + this.fmt(this.factors(i).coefD()) + ";");
                this.println("srcs[" + i + "]=" + this.fmt(this.factors(i).coefS()) + ";");
            }
            this.stopMethod();
        }
        if (this.doSolver(2)) {
            this.startMethod("Toms731_State__" + this.id, "t,x,us,uxs,cs,qs,rs", "double,double,double[],double[],double[],double[],double[]");
            this.loadCacheTXU();
            this.loadCacheUX();
            this.writeBlock(this.block);
            for (i = 0; i < this.n; ++i) {
                this.println("cs[" + i + "]=" + this.fmt(this.factors(i).toms731_C()) + ";");
                this.println("qs[" + i + "]=" + this.fmt(this.factors(i).toms731_Q()) + ";");
                this.println("rs[" + i + "]=" + this.fmt(this.factors(i).toms731_R()) + ";");
            }
            this.stopMethod();
        }
        this.writeMethods(true, this.lhbcBlock());
        this.writeMethods(false, this.rhbcBlock());
        this.println("");
    }

    private void writeMethods(boolean left, BCBlock bcblock) throws Xcept {
        int i;
        String sfx;
        String string = sfx = left ? "LHB" : "RHB";
        if (this.doSolver(0) || this.doSolver(1)) {
            this.startMethod("common_" + sfx + "__" + this.id, "t,us,f1s,f2s,f3s", "double,double[],double[],double[],double[]");
            this.loadCacheTU();
            this.loadCacheX(left);
            this.writeBlock(bcblock);
            for (i = 0; i < this.n; ++i) {
                this.println("f1s[" + i + "]=" + this.fmt(this.factors(i).coefF1(left)) + ";");
                this.println("f2s[" + i + "]=" + this.fmt(this.factors(i).coefF2(left)) + ";");
                this.println("f3s[" + i + "]=" + this.fmt(this.factors(i).coefF3(left)) + ";");
            }
            this.stopMethod();
        }
        if (this.doSolver(2)) {
            this.startMethod("Toms731_" + sfx + "__" + this.id, "t,us,uxs,betas,gammas", "double,double[],double[],double[],double[]");
            this.loadCacheTU();
            this.loadCacheUX();
            this.loadCacheX(left);
            this.writeBlock(bcblock);
            for (i = 0; i < this.n; ++i) {
                this.println("betas[" + i + "]=" + this.fmt(this.factors(i).toms731_Beta(left)) + ";");
                this.println("gammas[" + i + "]=" + this.fmt(this.factors(i).toms731_Gamma(left)) + ";");
            }
            this.stopMethod();
        }
    }

    protected void loadCache(Var v, String s) throws Xcept {
        this.println(this.vcache(v) + "=" + s + ";");
    }

    protected void loadCache(ArrayList<Var> vs, String s) throws Xcept {
        for (int i = 0; i < vs.size(); ++i) {
            Var v = vs.get(i);
            if (v == null) continue;
            this.println(this.vcache(v) + "=" + s + "[" + i + "];");
        }
    }

    protected void loadCacheTU() throws Xcept {
        this.loadCache(this.t, "t");
        this.loadCache(this.us, "us");
    }

    protected void loadCacheTXU() throws Xcept {
        this.loadCacheTU();
        this.loadCache(this.x, "x");
    }

    protected void loadCacheUX() throws Xcept {
        this.loadCache(this.uxs, "uxs");
    }

    protected void loadCacheX(boolean left) throws Xcept {
        RealNVar vaux = left ? this.x.vmin : this.x.vmax;
        this.println(this.vcache(this.x) + "=" + this.fmt((Expr)vaux) + ";");
    }

    public ArrayList<Var> vstate() {
        return this.block.vstate();
    }

    public BCBlock lhbcBlock() {
        return this.block.bcblock(this.x, true);
    }

    public BCBlock rhbcBlock() {
        return this.block.bcblock(this.x, false);
    }

    public boolean doSolver(int i) {
        return this.block.solverMsg(i) == null;
    }

    public PDE1Factors factors(int i) {
        return (PDE1Factors)this.block.factors(i);
    }

    public String evalMethod() {
        return "evaluate__" + this.id;
    }

    @Override
    public String extendsClass() {
        return "PDE1Problem";
    }
}

