/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JCacheVar;
import JSim.jcode2.JFPWriter;
import JSim.jcode2.JMainWriter;
import JSim.jcode2.JMethodWriter;
import JSim.jcode2.JProblemWriter;
import JSim.jcode2.JWriter;
import JSim.mml.ChoiceNVar;
import JSim.mml.Domain;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.ModelReader;
import JSim.mml.Var;
import JSim.plan2.ExprTool;
import JSim.plan2.MainBlock;
import JSim.plan2.MuBlock;
import JSim.plan2.Plan;
import JSim.plan2.QueryTool;
import JSim.plan2.SeqBlock;
import JSim.plan2.SeqItem;
import JSim.plan2.TModel;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPlanWriter
extends JWriter {
    protected Plan plan;
    protected JWriter.State state;
    protected LinkedHashSet<Var> rtvars;
    protected Hashtable<SeqItem, Integer> loopPhases;
    protected Hashtable<Var, Integer> varPhases;
    protected LinkedHashSet<JCacheVar> cacheVars;
    protected JMainWriter mainWriter;
    protected JFPWriter fpWriter;
    protected ArrayList<JMethodWriter> subWriters;
    protected StringList vtraces;

    public JPlanWriter(String className, Plan plan) throws Xcept {
        int i;
        this.plan = plan;
        this.state = new JWriter.State(className);
        if (this.mainBlock() == null) {
            throw new Xcept("Can't write java code - no sequencing info");
        }
        this.loopPhases = new Hashtable();
        this.varPhases = new Hashtable();
        ArrayList<SeqItem> items = this.mainBlock().items();
        Integer phase = new Integer(2);
        for (i = 0; i < items.size(); ++i) {
            SeqItem item = items.get(i);
            if (item instanceof SeqBlock.Loop) {
                phase = new Integer(phase + 1);
                this.loopPhases.put(item, phase);
                this.setPhase(item, phase);
                phase = new Integer(phase + 1);
                continue;
            }
            this.setPhase(item, phase);
        }
        this.rtvars = new LinkedHashSet();
        this.cacheVars = new LinkedHashSet();
        phase = new Integer(1);
        for (i = 0; i < this.math().nVar(); ++i) {
            Var v = this.math().var(i);
            Tool tool = this.mainTool(v);
            if (tool != null) {
                this.rtvars.add(v);
            }
            if (!this.box().isInput(tool)) continue;
            this.varPhases.put(v, phase);
            if (v.ndim() != 0) continue;
            this.cacheVars.add(new JCacheVar(v, 0));
        }
        this.mainWriter = new JMainWriter(this, this.mainBlock());
        this.fpWriter = new JFPWriter(this);
        this.subWriters = new ArrayList();
        this.addMethodWriters(this.mainWriter);
        for (i = 0; i < this.subWriters.size(); ++i) {
            JMethodWriter p = this.subWriters.get(i);
            int plevel = p.cacheLevel;
            for (Var v : p.cache) {
                this.cacheVars.add(new JCacheVar(v, plevel));
            }
        }
    }

    private void setPhase(SeqItem item, Integer phase) throws Xcept {
        block5: {
            block6: {
                block4: {
                    if (item instanceof QueryTool) {
                        return;
                    }
                    if (!(item instanceof MuBlock)) break block4;
                    ArrayList<Var> vs = ((MuBlock)item).vstate();
                    for (int i = 0; i < vs.size(); ++i) {
                        this.varPhases.put(vs.get(i), phase);
                    }
                    break block5;
                }
                if (!(item instanceof Tool)) break block6;
                VarUsages vus = ((Tool)item).vsols;
                Iterator vs = vus.vset().iterator();
                while (vs.hasNext()) {
                    this.varPhases.put((Var)((Object)vs.next()), phase);
                }
                break block5;
            }
            if (!(item instanceof SeqBlock.Loop)) break block5;
            ArrayList<SeqItem> subitems = ((SeqBlock.Loop)item).items();
            for (int i = 0; i < subitems.size(); ++i) {
                this.setPhase(subitems.get(i), phase);
            }
        }
    }

    public void setSourceLibs() throws Xcept {
        this.fpWriter.setSourceLibs();
    }

    private void addMethodWriters(JMethodWriter wrt) {
        for (int i = 0; i < wrt.subWriters.size(); ++i) {
            JMethodWriter wsub = wrt.subWriters.get(i);
            this.subWriters.add(wsub);
            this.addMethodWriters(wsub);
        }
    }

    public void writePlan() throws Xcept {
        this.writeHdr();
        this.indentIn();
        this.writeVarDecl();
        this.fpWriter.writeDecl();
        this.writeSolverDecl();
        this.writeConstrHdr();
        this.writeUnits();
        this.writeVarInsts();
        this.writeInputDefaults();
        this.fpWriter.writeInit();
        this.writeSolverInst();
        this.writeConstrFooter();
        this.writeMainMethods();
        this.fpWriter.writeJavaClasses();
        this.writeSolverClasses();
        this.writeCtxt();
        this.indentOut();
        this.println("}");
        this.println("");
        this.fpWriter.writeNativeFuncClasses();
        this.fpWriter.writeExternJava();
    }

    private void writeHdr() throws Xcept {
        this.println("// JSim generated model " + this.className());
        this.println(" ");
        this.println("import java.lang.Math;");
        this.println("import JSim.util.*;");
        this.println("import JSim.data.*;");
        this.println("import JSim.jruntime.*;");
        this.println("import JSim.aserver.*;");
        this.println("import JSim.nml.math.NatMath;");
        this.println(" ");
        this.println("// " + this.className() + " model");
        this.println("public class " + this.className() + " extends RTModel {");
        this.println("");
    }

    private void writeVarDecl() throws Xcept {
        this.println("// variable declarations");
        for (int i = 0; i < this.math().nVar(); ++i) {
            Var v = this.math().var(i);
            if (!this.rtvars.contains((Object)v)) continue;
            this.println("public " + this.rtClass(v) + " " + this.vstruct(v) + ";");
        }
        this.println(" ");
    }

    private void writeSolverDecl() throws Xcept {
        this.println("// solver declarations");
        for (int i = 0; i < this.subWriters.size(); ++i) {
            if (!(this.subWriters.get(i) instanceof JProblemWriter)) continue;
            ((JProblemWriter)this.subWriters.get(i)).writeDecl();
        }
        this.println(" ");
    }

    private void writeConstrHdr() throws Xcept {
        this.println("// RT model constructor");
        this.startMethod(this.className(), "u,m", "UnitNList,ASServer.Messenger");
        this.println("super(\"" + this.className() + "\"" + ", u, m);");
        this.println(" ");
    }

    private void writeUnits() throws Xcept {
        this.println("// units used in model");
        UnitNList units = this.mmlModel().units;
        for (int i = 0; i < units.fund.size(); ++i) {
            this.println("units.addFund(\"" + units.fund.str(i) + "\");");
        }
        Unit.List punits = new Unit.List(32);
        this.math().addSubUnits(punits, units);
        for (int i = 0; i < punits.size(); ++i) {
            Unit u = punits.unit(i);
            this.println("units.add(\"" + u.name() + "\", Unit.parse(this, \"" + u.fundStr(units) + "\"));");
        }
        this.println(" ");
    }

    private void writeVarInsts() throws Xcept {
        Var v;
        int i;
        this.println("// var instantiation");
        for (i = 0; i < this.math().nVar(); ++i) {
            v = this.math().var(i);
            if (!this.rtvars.contains((Object)v) || v.ndim() != 0) continue;
            this.writeVarInst(v);
        }
        for (i = 0; i < this.math().nVar(); ++i) {
            v = this.math().var(i);
            if (!this.rtvars.contains((Object)v) || !v.isDomain()) continue;
            this.writeVarInst(v);
        }
        for (i = 0; i < this.math().nVar(); ++i) {
            v = this.math().var(i);
            if (!this.rtvars.contains((Object)v) || v.isDomain() || v.ndim() <= 0) continue;
            this.writeVarInst(v);
        }
        this.println(" ");
    }

    private void writeVarInst(Var v) throws Xcept {
        String sdom;
        String sunit = Unit.same((Unit)v.unit(), (Unit)Unit.scalar()) ? "dimensionless" : v.unit().name();
        sunit = "\"" + sunit + "\"";
        int sphase = this.phase(v);
        if (v.isDomain()) {
            Domain x = (Domain)v;
            sdom = this.vstruct(x.vmin) + "," + this.vstruct(x.vmax) + "," + this.vstruct(x.vdelta) + "," + this.vstruct(x.vct);
        } else if (v.ndim() == 0) {
            sdom = "null";
        } else {
            sdom = "new RTRealDomain[] {";
            for (int j = 0; j < v.ndim(); ++j) {
                Domain x = v.domain(j);
                if (j > 0) {
                    sdom = sdom + ",";
                }
                sdom = sdom + this.vstruct(x);
            }
            sdom = sdom + "}";
        }
        String slabels = "";
        if (v instanceof ChoiceNVar) {
            ChoiceNVar cv = (ChoiceNVar)v;
            slabels = ", new String[] { " + cv.labels().toString(",", true) + "}" + "," + " new String[] {" + cv.values().toString(",", true) + "}";
        }
        this.println(this.vstruct(v) + " = new " + this.rtClass(v) + "(this, " + "\"" + (Object)((Object)v) + "\"" + "," + sunit + "," + sphase + "," + sdom + slabels + ");");
        if (v.isPrivate()) {
            this.println(this.vstruct(v) + ".setPrivate();");
        }
    }

    private void writeInputDefaults() throws Xcept {
        this.println("// input defaults");
        for (int i = 0; i < this.math().nVar(); ++i) {
            Var v = this.math().var(i);
            if (!(this.mainTool(v) instanceof ExprTool) || !this.isInput(v)) continue;
            ExprTool tool = (ExprTool)this.mainTool(v);
            this.println(this.vstruct(v) + ".setDefault(" + "\"" + tool.expr.expr() + "\"" + ");");
        }
        this.println("");
    }

    private void writeSolverInst() throws Xcept {
        this.println("// solver instantiation");
        for (int i = 0; i < this.subWriters.size(); ++i) {
            if (!(this.subWriters.get(i) instanceof JProblemWriter)) continue;
            ((JProblemWriter)this.subWriters.get(i)).writeInst();
        }
        this.println("");
    }

    private void writeConstrFooter() throws Xcept {
        this.stopMethod();
        this.println("");
    }

    private void writeMainMethods() throws Xcept {
        boolean unitCorr = this.mmlModel().unitControl == 2;
        boolean allowMP = true;
        this.println("// simple main methods");
        this.println("public boolean defaultUnitCorrect() { return " + unitCorr + "; }");
        this.println("public boolean allowMPRuns() { return " + allowMP + "; }");
        this.println("public void mainline(RTContext ctxt) throws Xcept { ((XContext) ctxt).mainline(); }");
        this.println("public RTContext newRunContext(int threadInx, int nproc, RTDataStore s) { return new XContext(this, threadInx, nproc, s); }");
        this.println("");
    }

    private void writeSolverClasses() throws Xcept {
        for (int i = 0; i < this.subWriters.size(); ++i) {
            if (!(this.subWriters.get(i) instanceof JProblemWriter)) continue;
            ((JProblemWriter)this.subWriters.get(i)).writeClass();
        }
    }

    private void writeCtxt() throws Xcept {
        this.println("// model-specific context");
        this.println("public class XContext extends RTContext {");
        this.indentIn();
        this.writeGlobalCache();
        this.println("// context constructor");
        this.println("public XContext(RTModel m, int threadInx, int nproc, RTDataStore s) { super(m, threadInx, nproc, s, false); }");
        this.println("");
        this.println("// trace NaN causes abort?");
        this.println("public boolean abortNaN() { return " + this.plan.abortNaN() + "; }");
        this.println("");
        this.mainWriter.writeMethods();
        for (int i = 0; i < this.subWriters.size(); ++i) {
            this.subWriters.get(i).writeMethods();
        }
        this.fpWriter.writeMethods();
        this.indentOut();
        this.println("}");
        this.println(" ");
    }

    private void writeGlobalCache() throws Xcept {
        this.println("// global caches");
        for (JCacheVar cv : this.cacheVars) {
            this.println("private double " + this.vcache(cv.v, cv.level) + (this.plan.initNaN() ? " = Double.NaN;" : ";"));
        }
        this.println("");
    }

    protected void initCaches() throws Xcept {
        if (!this.plan.initNaN()) {
            return;
        }
        this.println("// initNaN=true: init cache vars to NaNs");
        for (JCacheVar cv : this.cacheVars) {
            this.println(this.vcache(cv.v, cv.level) + "=Double.NaN;");
        }
        this.println("");
    }

    protected boolean traceVar(Var v) throws Xcept {
        if (this.vtraces == null) {
            this.vtraces = new StringList(this.plan.traceVars(), ", ");
        }
        return this.vtraces.containSame(v.toString());
    }

    protected boolean checkNaN() throws Xcept {
        return this.plan.traceNaN() || this.plan.abortNaN();
    }

    @Override
    public JWriter.State state() {
        return this.state;
    }

    public TModel model() {
        return this.plan.model();
    }

    public ToolBox box() {
        return this.plan.box();
    }

    public Model mmlModel() {
        return this.model().mmlModel();
    }

    public MathSys math() {
        return this.model().math();
    }

    public MainBlock mainBlock() {
        return this.plan.main();
    }

    public Hashtable<VarUsage, Tool> vuTools() {
        return this.mainBlock().vuTools();
    }

    protected Tool mainTool(Var v) throws Xcept {
        VarUsage vu = new VarUsage(this.model(), v);
        return this.vuTools().get(vu);
    }

    protected int phase(Var v) throws Xcept {
        return this.varPhases.get((Object)v);
    }

    protected boolean isInput(Var v) throws Xcept {
        return this.phase(v) == 1;
    }

    public String rtClass(Var v) {
        String s1;
        String string = s1 = v.isInt() ? "Int" : "Real";
        if (v instanceof ChoiceNVar) {
            s1 = "Choice";
        }
        String s2 = v.isDomain() ? "Domain" : "NVar";
        return "RT" + s1 + s2;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Exception("Usage: JPlanWriter mod-file");
        }
        String modName = args[0];
        ModelReader mmlModel = new ModelReader(modName);
        mmlModel.flatten("testwriter.junk");
        Plan plan = new Plan(mmlModel);
        plan.process();
        if (plan.logger.errors.size() > 0) {
            throw new Exception("Compilation error(s): " + plan.logger.errors);
        }
        JPlanWriter wrt = new JPlanWriter("JTest", plan);
        wrt.writePlan();
    }
}

