/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode2;

import JSim.jcode2.JLang;
import JSim.mml.Var;
import JSim.util.Lang;
import JSim.util.RealConst;
import JSim.util.Xcept;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JWriter {
    protected Lang jlang = JLang.lang;
    protected static int methodLineMax = 1000;
    protected static int methodCharMax = 32000;
    protected static final String Q = "\"";
    protected static final String C = ",";
    protected static final String S = " ";

    public abstract State state();

    public void setFile(File f) throws Xcept {
        try {
            this.state().out = new PrintWriter((Writer)new FileWriter(f), true);
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    public String vstruct(Var v) {
        return "JS" + this.vname(v);
    }

    public String vstruct(ArrayList<Var> vs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vs.size(); ++i) {
            if (i > 0) {
                buf.append(C);
            }
            buf.append(this.vstruct(vs.get(i)));
        }
        return buf.toString();
    }

    public String vcache(Var v, int level) {
        return "js" + level + this.vname(v);
    }

    public String vcurr(Var v) {
        return "realVal(" + this.vstruct(v) + ")";
    }

    public String vname(Var v) {
        StringBuffer buf = new StringBuffer();
        String sv = v.toString();
        block4: for (int i = 0; i < sv.length(); ++i) {
            char c = sv.charAt(i);
            switch (c) {
                case ':': {
                    buf.append("__D");
                    continue block4;
                }
                case '.': {
                    buf.append("__");
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected String fmt(String f, String[] args) {
        StringBuffer buf = new StringBuffer(f + "(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buf.append(C);
            }
            buf.append(args[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    protected String fmt(RealConst c) {
        double d = c.realVal(null);
        if (Double.isNaN(d)) {
            return "Double.NaN";
        }
        return c.toString();
    }

    protected void startMethod(String name, String args, String argTypes) throws Xcept {
        this.state().methodName = name;
        this.state().methodArgs = args;
        this.state().methodArgTypes = argTypes;
        this.state().methodSfx = 0;
        this.writeMethod();
    }

    protected void writeMethod() throws Xcept {
        this.state().methodLineCt = 0;
        this.state().methodCharCt = 0;
        StringTokenizer argToks = new StringTokenizer(this.state().methodArgs, C);
        StringTokenizer typeToks = new StringTokenizer(this.state().methodArgTypes, C);
        if (argToks.countTokens() != typeToks.countTokens()) {
            throw new Xcept("Mismatched state().method args (" + this.state().methodArgs + ") and types (" + this.state().methodArgTypes + ")");
        }
        int n = argToks.countTokens();
        StringBuffer buf = new StringBuffer("public ");
        if (this.state().methodSfx > 0 || !this.state().methodName.equals(this.state().className)) {
            buf.append("void ");
        }
        buf.append(this.state().methodName);
        if (this.state().methodSfx > 0) {
            buf.append("__" + this.state().methodSfx);
        }
        buf.append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(C);
            }
            buf.append(typeToks.nextToken() + S + argToks.nextToken());
        }
        buf.append(") throws Xcept {");
        this.println(buf.toString());
        this.indentIn();
    }

    protected void stopMethod() throws Xcept {
        this.state().methodName = null;
        this.indentOut();
        this.println("}");
    }

    protected void println(String s) throws Xcept {
        if (this.isMethodTooBig()) {
            this.state().methodLineCt = 0;
            this.state().methodCharCt = 0;
            ++this.state().methodSfx;
            this.println(this.state().methodName + "__" + this.state().methodSfx + "(" + this.state().methodArgs + ");");
            this.indentOut();
            this.println("}");
            this.writeMethod();
        }
        this.state().out.println(this.state().indent + s);
        ++this.state().methodLineCt;
        this.state().methodCharCt += s.length();
    }

    protected boolean isMethodTooBig() {
        if (this.state().methodName == null) {
            return false;
        }
        return this.state().methodLineCt > methodLineMax || this.state().methodCharCt > methodCharMax;
    }

    protected void indentIn() {
        this.state().indent = "    " + this.state().indent;
    }

    protected void indentOut() {
        this.state().indent = this.state().indent.substring(4);
    }

    public String className() {
        return this.state().className;
    }

    public static class State {
        protected String className;
        protected File outFile;
        protected PrintWriter out;
        protected String indent;
        protected String methodName;
        protected String methodArgs;
        protected String methodArgTypes;
        protected int methodLineCt;
        protected int methodCharCt;
        protected int methodSfx;

        public State(String className) {
            this.className = className;
            this.out = new PrintWriter(System.out, true);
            this.indent = "";
        }
    }
}

