/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTProblem;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.nml.Solver;
import JSim.nml.pde1.PDE1Callbacks;
import JSim.nml.pde1.PDE1Solver;
import JSim.util.DiagInfo;
import JSim.util.NamedExpr;
import JSim.util.Xcept;

public abstract class PDE1Problem
extends RTProblem
implements PDE1Callbacks {
    protected RTRealDomain t;
    protected RTRealDomain x;
    protected int nu;
    protected int nv;
    protected int nxcpl;
    protected RTRealNVar[] ustate;
    protected RTRealNVar[] ustatet;
    protected RTRealNVar[] ustatex;
    protected RTRealNVar[] ustatext;
    protected RTRealNVar[] ustatexx;
    protected RTRealNVar[] vstate;
    protected RTRealNVar[] vstatet;

    public PDE1Problem(RTModel m, String n) throws Xcept {
        super(m, n);
    }

    public void setup(RTRealDomain tt, RTRealDomain xx, int nnxcpl, RTRealNVar[] uu, RTRealNVar[] uut, RTRealNVar[] uux, RTRealNVar[] uuxt, RTRealNVar[] uuxx, RTRealNVar[] vv, RTRealNVar[] vvt) throws Xcept {
        this.t = tt;
        this.x = xx;
        this.nu = uu.length;
        this.nv = vv == null ? 0 : vv.length;
        this.nxcpl = nnxcpl;
        this.ustate = uu;
        this.ustatet = uut;
        this.ustatex = uux;
        this.ustatext = uuxt;
        this.ustatexx = uuxx;
        this.vstate = vv;
        this.vstatet = vvt;
    }

    public Solver createSolver(int solverInx, RTContext ctxt) throws Xcept {
        PDE1Solver solver = new PDE1Solver(this, solverInx, ctxt, this.nu);
        String[] varNames = new String[this.ustate.length];
        for (int i = 0; i < this.ustate.length; ++i) {
            varNames[i] = this.ustate[i].toString();
        }
        solver.setVarNames(varNames);
        return solver;
    }

    public void solve(RTContext ctxt) throws Xcept {
        int i;
        this.init(ctxt);
        PDE1Solver solver = (PDE1Solver)this.solver(ctxt);
        if (ctxt.atRHBC(this.t)) {
            return;
        }
        int xstate = ctxt.getState(this.x);
        int nx = ctxt.ct(this.x);
        double[][] u0 = new double[this.nu][nx];
        double[][] uf = new double[this.nu][nx];
        double[][] ut0 = new double[this.nu][nx];
        double[][] utf = new double[this.nu][nx];
        double[][] ux0 = new double[this.nu][nx];
        double[][] uxf = new double[this.nu][nx];
        double[][] uxt0 = new double[this.nu][nx];
        double[][] uxtf = new double[this.nu][nx];
        double[] v0 = new double[this.nv];
        double[] vf = new double[this.nv];
        double[] vt0 = new double[this.nv];
        double[] vtf = new double[this.nv];
        double[] xcpl = new double[this.nxcpl];
        for (i = 0; i < this.nu; ++i) {
            RTRealNVar u = this.ustate[i];
            for (int j = 0; j < nx; ++j) {
                ctxt.setInx(this.x, j);
                u0[i][j] = ctxt.realVal(u);
                uf[i][j] = Double.NaN;
                ut0[i][j] = Double.NaN;
                utf[i][j] = Double.NaN;
                ux0[i][j] = Double.NaN;
                uxf[i][j] = Double.NaN;
                uxt0[i][j] = Double.NaN;
                uxtf[i][j] = Double.NaN;
            }
        }
        for (i = 0; i < this.nv; ++i) {
            RTRealNVar v = this.vstate[i];
            v0[i] = ctxt.realVal(v);
            vf[i] = Double.NaN;
            vt0[i] = Double.NaN;
            vtf[i] = Double.NaN;
        }
        for (i = 0; i < this.nxcpl; ++i) {
            xcpl[i] = Double.NaN;
        }
        if (this.nxcpl > 0) {
            this.calcXcpl(xcpl);
        }
        if (ctxt.atLHBC(this.t)) {
            int i2;
            double[] u = new double[this.nu];
            double[] ux = new double[this.nu];
            double[] beta = new double[this.nu];
            double[] gamma = new double[this.nu];
            ctxt.setLHBC(this.x);
            for (i2 = 0; i2 < this.nu; ++i2) {
                u[i2] = u0[i2][0];
                ux[i2] = Double.NaN;
            }
            this.Toms731_LHB(ctxt, ctxt.realVal(this.t), u, ux, beta, gamma);
            for (i2 = 0; i2 < this.nu; ++i2) {
                if (beta[i2] != 0.0 || Double.isNaN(gamma[i2]) || gamma[i2] == 0.0) continue;
                this.model.badICBC("IC/LHBC inconsistency for state var " + (Object)((Object)this.ustate[i2]), (NamedExpr)this.ustate[i2], gamma[i2]);
            }
            ctxt.setRHBC(this.x);
            for (i2 = 0; i2 < this.nu; ++i2) {
                u[i2] = u0[i2][nx - 1];
            }
            this.Toms731_RHB(ctxt, ctxt.realVal(this.t), u, ux, beta, gamma);
            for (i2 = 0; i2 < this.nu; ++i2) {
                if (beta[i2] != 0.0 || Double.isNaN(gamma[i2]) || gamma[i2] == 0.0) continue;
                this.model.badICBC("IC/RHBC inconsistency for state var " + (Object)((Object)this.ustate[i2]), (NamedExpr)this.ustate[i2], gamma[i2]);
            }
        }
        double t0 = ctxt.realVal(this.t);
        double tf = t0 + ctxt.delta(this.t);
        solver.solve(ctxt, t0, tf, ctxt.grid(this.x).samples(), u0, uf, ut0, utf, ux0, uxf, uxt0, uxtf, v0, vf, vt0, vtf);
        if (ctxt.atLHBC(this.t)) {
            this.saveArrays(ctxt, null, ut0, ux0, uxt0, null, vt0);
        }
        ctxt.moveRight(this.t);
        this.saveArrays(ctxt, uf, utf, uxf, uxtf, vf, vtf);
        ctxt.moveLeft(this.t);
        ctxt.setState(this.x, xstate);
    }

    private void saveArrays(RTContext ctxt, double[][] u, double[][] ut, double[][] ux, double[][] uxt, double[] v, double[] vt) throws Xcept {
        int i;
        for (i = 0; i < this.nu; ++i) {
            RTRealNVar uu = u == null ? null : this.ustate[i];
            RTRealNVar uut = this.ustatet[i];
            RTRealNVar uux = this.ustatex[i];
            RTRealNVar uuxt = this.ustatext == null ? null : this.ustatext[i];
            int nx = ctxt.ct(this.x);
            for (int j = 0; j < nx; ++j) {
                ctxt.setInx(this.x, j);
                if (uu != null) {
                    ctxt.set(uu, u[i][j]);
                }
                if (uut != null) {
                    ctxt.set(uut, ut[i][j]);
                }
                if (uux != null) {
                    ctxt.set(uux, ux[i][j]);
                }
                if (uuxt == null) continue;
                ctxt.set(uuxt, uxt[i][j]);
            }
        }
        for (i = 0; i < this.nv; ++i) {
            RTRealNVar vv = v == null ? null : this.vstate[i];
            RTRealNVar vvt = this.vstatet[i];
            if (vv != null) {
                ctxt.set(vv, v[i]);
            }
            ctxt.set(vvt, vt[i]);
        }
    }

    public void calcXcpl(double[] xcpl) throws Xcept {
        throw new Xcept((DiagInfo)this, "calcXcpl() not implemented");
    }

    public void Toms731_BC(RTContext ctxt, int left, double t, double[] u, double[] ux, double[] BETA, double[] GAMMA) throws Xcept {
        if (left == 1) {
            this.Toms731_LHB(ctxt, t, u, ux, BETA, GAMMA);
        } else {
            this.Toms731_RHB(ctxt, t, u, ux, BETA, GAMMA);
        }
    }

    public String desc() {
        return "PDE solver";
    }

    public RTRealNVar[] getStatevars() {
        return this.ustate;
    }

    public void common_LHB(RTContext ctxt, double t, double[] uc, double[] f1, double[] f2, double[] f3) throws Xcept {
        throw new Xcept((DiagInfo)this, "common_LHB not implemented");
    }

    public void common_RHB(RTContext ctxt, double t, double[] uc, double[] f1, double[] f2, double[] f3) throws Xcept {
        throw new Xcept((DiagInfo)this, "common_RHB not implemented");
    }

    public void LSFEA_tstep(RTContext ctxt, double t, double x, double[] u, double[] ut) throws Xcept {
        throw new Xcept((DiagInfo)this, "LSFEA_tstep not implemented");
    }

    public void LSFEA_xstep(RTContext ctxt, double t, double x, double[] u, double[] uxcoef, double[] uxxcoef) throws Xcept {
        throw new Xcept((DiagInfo)this, "LSFEA_xstep not implemented");
    }

    public double LSFEA_setX(RTContext ctxt, int xinx) throws Xcept {
        ctxt.setInx(this.x, xinx);
        return ctxt.realVal(this.x);
    }

    public void MacCormack_State(RTContext ctxt, double t, double x, double[] uc, double[] cX, double[] cXX, double[] src) throws Xcept {
        throw new Xcept((DiagInfo)this, "MacCormack_State not implemented");
    }

    public void Toms731_State(double t, double x, double[] u, double[] ux, double[] C, double[] Q, double[] R) throws Xcept {
        throw new Xcept((DiagInfo)this, "Toms731_CQR not implemented");
    }

    public void Toms731_LHB(RTContext ctxt, double t, double[] u, double[] ux, double[] BETA, double[] GAMMA) throws Xcept {
        throw new Xcept((DiagInfo)this, "Toms731_LHB not implemented");
    }

    public void Toms731_RHB(RTContext ctxt, double t, double[] u, double[] ux, double[] BETA, double[] GAMMA) throws Xcept {
        throw new Xcept((DiagInfo)this, "Toms731_RHB not implemented");
    }

    public void Toms731_embedU0(RTContext ctxt, double[][] u0, double[] u) throws Xcept {
        int nx = ctxt.ct(this.x);
        for (int i = 0; i < this.nu; ++i) {
            for (int j = 0; j < nx; ++j) {
                u[i + j * (1 + this.nu)] = u0[i][j];
            }
        }
    }
}

