/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.Data;
import JSim.data.GridData;
import JSim.data.RealNData;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.jruntime.RTVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;
import java.util.ArrayList;

public class RTLiveQuery
implements DiagInfo {
    private RTModel model;
    private Expr oexpr;
    private Expr uexpr;
    private Expr.List domains;
    private int phase;
    private RTRealDomain liveDomain;
    private Data data;
    private boolean complete;

    protected RTLiveQuery(RTModel m, Expr e) throws Xcept {
        this.model = m;
        this.oexpr = e;
        this.uexpr = this.model.unitCorrect ? this.oexpr.unitCorrect() : this.oexpr;
        this.domains = new Expr.List(2);
        this.oexpr.addDomains(this.domains);
        Expr.List vars = new Expr.List(2);
        this.oexpr.addNamedExpr(vars);
        this.phase = 0;
        for (int i = 0; i < vars.size(); ++i) {
            int p;
            Expr v = vars.expr(i);
            if (!(v instanceof RTVar) || (p = ((RTVar)v).phase()) <= this.phase) continue;
            this.phase = p;
        }
    }

    protected Data getAllData(RTContext ctxt) throws Xcept {
        if (this.complete) {
            return this.data;
        }
        if (this.data == null) {
            this.data = this.model.getAllData(ctxt, this.oexpr, null, null);
            this.complete = true;
            return this.data;
        }
        this.update(ctxt, this.liveDomain, ctxt.ct(this.liveDomain));
        return this.data;
    }

    protected void update(RTContext ctxt, RTRealDomain x, int hix) throws Xcept {
        if (x == null) {
            throw new Xcept("RTLiveQuery update domain is null");
        }
        if (this.liveDomain == null) {
            this.liveDomain = x;
        }
        if (x != this.liveDomain) {
            throw new Xcept((DiagInfo)x, (DiagInfo)this.liveDomain, "RTLiveQuery domain conflict");
        }
        if (this.data == null) {
            this.data = this.makeData(ctxt);
        }
        if (!(this.oexpr instanceof RTVar)) {
            for (int i = this.data.subset.hix; i < hix; ++i) {
                this.calcData(ctxt, i);
            }
        }
        this.data.subset.hix = hix;
        if (hix == ctxt.ct(this.liveDomain)) {
            this.complete = true;
        }
    }

    private Data makeData(RTContext ctxt) throws Xcept {
        if (this.uexpr instanceof RTRealNVar) {
            this.data = ctxt.ndata((RTRealNVar)this.uexpr);
        } else if (this.uexpr instanceof RTRealDomain) {
            this.data = ctxt.grid((RTRealDomain)this.uexpr);
        } else {
            String desc = this.oexpr.toString();
            Unit u = this.uexpr.unit();
            GridData[] grids = new GridData[this.domains.size()];
            int j = 0;
            for (int i = 0; i < this.domains.size(); ++i) {
                RTRealDomain x = (RTRealDomain)((Object)this.domains.get(i));
                grids[j++] = ctxt.grid(x);
            }
            this.data = new RealNData(desc, u, grids);
        }
        this.data.subset = new Data.Subset();
        this.data.subset.gridInx = this.domains.indexOf((Object)this.liveDomain);
        if (this.data.subset.gridInx < 0) {
            throw new Xcept((DiagInfo)this.uexpr, (DiagInfo)this.liveDomain, "RTLiveQuery domain missing");
        }
        return this.data;
    }

    private void calcData(RTContext ctxt, int xinx) throws Xcept {
        if (this.data.ndim() == 1) {
            ctxt.setInx(this.liveDomain, xinx);
            double d = this.uexpr.realVal((Context)ctxt);
            ((RealNData)this.data).set(xinx, d);
            return;
        }
        if (this.data.ndim() != 2) {
            return;
        }
        RTRealDomain x = (RTRealDomain)this.domains.expr(0);
        RTRealDomain y = (RTRealDomain)this.domains.expr(1);
        boolean xlive = x == this.liveDomain;
        RTRealDomain deadDomain = xlive ? y : x;
        int deadInx = xlive ? 1 : 0;
        int[] gpos = new int[]{xinx, xinx};
        ctxt.setInx(this.liveDomain, xinx);
        int i = 0;
        while (i < ctxt.ct(deadDomain)) {
            ctxt.setInx(deadDomain, i);
            double d = this.uexpr.realVal((Context)ctxt);
            gpos[deadInx] = i++;
            int inx = this.data.inx(gpos);
            ((RealNData)this.data).set(inx, d);
        }
    }

    public int phase() {
        return this.phase;
    }

    public Data data() {
        return this.data;
    }

    public String diagInfo() {
        return "Live Query " + this.oexpr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<RTLiveQuery> {
        public RTLiveQuery query(int i) {
            return (RTLiveQuery)this.get(i);
        }

        public RTLiveQuery query(Expr e) {
            for (int i = 0; i < this.size(); ++i) {
                if (!e.sameAs(this.query(i).oexpr)) continue;
                return this.query(i);
            }
            return null;
        }
    }
}

