/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.aserver.ASVar;
import JSim.data.Data;
import JSim.jruntime.RTDataStore;
import JSim.jruntime.RTModel;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.NamedList;
import JSim.util.Unit;
import JSim.util.Xcept;

public abstract class RTVar
extends ASVar {
    protected RTModel model;
    protected String name;
    protected Unit unit;
    protected Expr defAssign;
    protected Expr assign;
    private boolean isPrivate;
    private int phase;
    public static final int INPUT = 1;
    private int varID;

    public RTVar(RTModel m, String n, String u, int ph) throws Xcept {
        this.model = m;
        this.name = n;
        this.unit = this.model.parseUnit(u);
        this.phase = ph;
        this.isPrivate = false;
        this.varID = this.model.vars.size();
        this.model.add(this);
    }

    public void setDefault() throws Xcept {
        if (this.defAssign != null) {
            this.setAssign(this.defAssign.toString());
        }
    }

    public void setDefault(String n) throws Xcept {
        Expr e = this.model.parseExpr(n).simplify();
        this.checkAssign(e);
        this.defAssign = e;
        this.assign = e;
    }

    public void setAssign(String s) throws Xcept {
        if (s == null) {
            this.assign = null;
            return;
        }
        try {
            Expr expr = this.model.parseExpr(s);
            this.checkAssign(expr);
            this.assign = expr;
        }
        catch (Exception e) {
            this.assign = null;
            throw Xcept.wrap((Throwable)e);
        }
    }

    public final String getAssign() {
        return this.assign == null ? null : this.assign.toString();
    }

    public final String getDefault() {
        return this.defAssign == null ? null : this.defAssign.toString();
    }

    public void setPrivate() {
        this.isPrivate = true;
    }

    public void setName(String n) {
        this.name = n;
    }

    public final String toString() {
        return this.name;
    }

    public final Unit unit() {
        return this.unit;
    }

    public final Expr unitCorrect() {
        return this;
    }

    public final String name() {
        return this.name;
    }

    public final boolean isInput() {
        return this.phase == 1;
    }

    public final int phase() {
        return this.phase;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final int dataType() {
        return 4;
    }

    public final int varID() {
        return this.varID;
    }

    public List domainList() {
        List list = new List(this.ndim());
        this.addDomains((Expr.List)list);
        return list;
    }

    public final boolean sameAs(Expr e) {
        return e == this;
    }

    public String toString(Context ctxt) {
        return ctxt.lang.newName(this.name);
    }

    public void setUnit(String s) throws Xcept {
        throw new Xcept((DiagInfo)this, "setUnit() not implemented");
    }

    public final double finalRealVal() throws Xcept {
        RTDataStore store = this.model.finalStore();
        if (store == null) {
            return Double.NaN;
        }
        Data data = store.data(this);
        if (data == null || data.nsamples() < 1) {
            return Double.NaN;
        }
        return data.realVal(data.nsamples() - 1);
    }

    public final void checkAssign(Expr e) throws Xcept {
        this.checkAssign(e, this.model.unitCorrect);
    }

    private void checkAssign(Expr e, boolean unitCorrect) throws Xcept {
        Unit u;
        if (!this.isInput()) {
            throw new Xcept((DiagInfo)this, "User may not assign values to output variables.");
        }
        ASVar.List vlist = new ASVar.List(1);
        for (int i = 0; i < this.ndim(); ++i) {
            vlist.add((Object)this.domain(i));
        }
        ASVar.List elist = new ASVar.List(1);
        e.addDomains((Expr.List)elist);
        if (!vlist.containSet((Expr.List)elist)) {
            throw new Xcept((DiagInfo)this, (DiagInfo)e, "Variable assignment invalid due to domain conflict");
        }
        Expr.List xlist = new Expr.List(1);
        e.addNamedExpr(xlist);
        for (int i = 0; i < xlist.size(); ++i) {
            ASVar v;
            if (!(xlist.expr(i) instanceof ASVar) || (v = (ASVar)xlist.expr(i)).isInput() || v.ndim() == 0 || v.isDomain()) continue;
            throw new Xcept((DiagInfo)this, (DiagInfo)v, "May not calculate input variable from output variables");
        }
        if (unitCorrect && !Unit.compatible((Unit)(u = e.unitCorrect().unit()), (Unit)this.unit())) {
            throw new Xcept((DiagInfo)this, (DiagInfo)e, "Assignment units are incompatible");
        }
    }

    public static class NList
    extends NamedList {
        public NList(int i) {
            super(i);
        }

        public RTVar var(int i) {
            return (RTVar)((Object)this.get(i));
        }

        public RTVar var(String n) {
            return (RTVar)((Object)this.getByName(n));
        }
    }

    public static class List
    extends ASVar.List {
        public List(int i) {
            super(i);
        }

        public RTVar var(int i) {
            return (RTVar)((Object)this.get(i));
        }
    }
}

