/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.data.RealNData;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTXFunc;
import JSim.jruntime.RTXFuncArg;
import JSim.util.DiagInfo;
import JSim.util.Xcept;

public class RTXFuncCall
implements DiagInfo {
    private RTXFunc func;
    protected RTXFuncArg.List args;

    public RTXFuncCall(RTXFunc f) {
        this.func = f;
        this.args = new RTXFuncArg.List(4);
    }

    protected void addArg(RTXFuncArg arg) {
        this.args.add(arg);
    }

    public String name() {
        return this.func.name();
    }

    public String diagInfo() {
        return "Function call " + this.func.name();
    }

    public RTXFunc func() {
        return this.func;
    }

    private RealNData[] makeArgs(RTContext ctxt) throws Xcept {
        RealNData[] nargs = new RealNData[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            nargs[i] = this.args.arg(i).loadData(ctxt);
        }
        return nargs;
    }

    public double realVal(RTContext ctxt) throws Xcept {
        return this.func.realCalculate(this.makeArgs(ctxt));
    }

    public void voidVal(RTContext ctxt) throws Xcept {
        RealNData[] nargs = this.makeArgs(ctxt);
        this.func.voidCalculate(nargs);
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.arg(i).unloadData(ctxt, nargs[i]);
        }
    }
}

