/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASConstraint;
import JSim.aserver.ASInfo;
import JSim.aserver.ASModel;
import JSim.aserver.ASQuery;
import JSim.aserver.ASServer;
import JSim.aserver.ASVar;
import JSim.data.Data;
import JSim.data.FimData;
import JSim.data.NamedVal;
import JSim.data.OptimResults;
import JSim.data.XMLWriter;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTQuery;
import JSim.jruntime.RTVar;
import JSim.lserver.LSModelFim;
import JSim.lserver.LSModelOptim;
import JSim.lserver.LSPlan;
import JSim.lserver.LSPlan16;
import JSim.lserver.LSPlan20;
import JSim.lserver.LSServer;
import JSim.mathml.MLWriter;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.ModelReader;
import JSim.mml.SourceFunc;
import JSim.plan.BuildControl;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.MPDispatch;
import JSim.util.Named;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.UtilXML;
import JSim.util.XFunc;
import JSim.util.Xcept;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LSModel
implements DiagInfo,
ASModel,
BuildControl,
MPDispatch.Monitor,
ASServer.Messenger {
    private static int seq = 100;
    private LSServer server;
    private ASInfo.Build buildInfo;
    private boolean cancelBuild;
    private String name;
    private Model flatModel;
    private LSPlan plan;
    private RTModel rtmodel;
    private String mmlText;
    private File flatFile;
    private File javaFile;
    private int maxBuildTime;
    private long buildStartTime;
    private NamedVal.NList props;
    private ASConstraint.List constraints;
    private String[] modelTextCache;
    private LSPlan sbmlPlan;
    private int storeMode;
    protected ASInfo.Status jobStat;
    private LSModelOptim optim;
    private LSModelFim fim;

    public LSModel(LSServer s) {
        this.server = s;
        this.unbuildRT();
    }

    public void unbuildRT() {
        this.flatModel = null;
        this.plan = null;
        this.rtmodel = null;
        this.mmlText = null;
        this.javaFile = null;
        this.flatFile = null;
        this.props = null;
        this.constraints = null;
        this.storeMode = 0;
        this.optim = null;
        this.modelTextCache = null;
        this.jobStat = new ASInfo.Status(0);
    }

    public void buildRT(ASInfo.Build binfo) throws Xcept {
        this.unbuildRT();
        this.cancelBuild = false;
        this.buildInfo = binfo;
        this.maxBuildTime = binfo.options.intVal("maxBuildTime", 120);
        int smax = this.server.maxBuildTime();
        if (smax > 0 && smax < this.maxBuildTime) {
            this.maxBuildTime = smax;
        }
        this.buildStartTime = System.currentTimeMillis();
        try {
            this.buildRT1();
            this.server.scrubBuildDir();
        }
        catch (Exception e) {
            this.server.scrubBuildDir();
            throw Xcept.wrap((Throwable)e);
        }
    }

    private void buildRT1() throws Xcept {
        this.modelTextCache = new String[ASModel.TEXT_NAMES.length];
        File buildDir = this.server.buildDir;
        this.name = this.buildInfo.name.replace('.', '_');
        String modelSource = this.buildInfo.modelSource + "\n";
        int sourceType = this.buildInfo.sourceType;
        String auxName = this.buildInfo.auxName;
        ClassLoader classLoader = this.server.classLoader;
        Util.verbose((String)("==== Build directory is " + buildDir));
        if (!buildDir.exists()) {
            Util.verbose((String)("\tCreating working directory " + buildDir));
            if (!buildDir.mkdir()) {
                throw new Xcept("Could not create directory " + buildDir);
            }
        }
        String className = "JS" + seq++ + this.name;
        this.javaFile = new File(buildDir, className + ".java");
        File classFile = new File(buildDir, className + ".class");
        this.mmlText = null;
        this.flatFile = null;
        if (sourceType == 1) {
            String sstr = modelSource;
            StringReader rdr = new StringReader(sstr);
            this.flatModel = new ModelReader(rdr, classLoader, this.server.jsimPath());
            if (this.server.sandbox != null) {
                this.flatModel.checkSandbox();
            }
            this.mmlText = modelSource;
            this.flatFile = new File(buildDir, className + ".flat");
            this.flatModel.flatten(this.flatFile.getPath());
            MathSys math = this.flatModel.getFlatMath();
            this.plan = Util.v2 ? new LSPlan20(this.flatModel, this.buildInfo().options) : new LSPlan16(this.flatModel, this);
            this.plan.makePlan();
            XFunc.NList funcs = this.flatModel.neededFuncs();
            for (int i = 0; i < funcs.size(); ++i) {
                XFunc f = funcs.xfunc(i);
                if (!(f instanceof SourceFunc)) continue;
                switch (f.lang()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        this.server.nativeCompiler.compile(className, (SourceFunc)f);
                    }
                }
            }
            Util.verbose((String)("\tWriting generated Java model code to " + this.javaFile));
            this.plan.writeJava(className, this.javaFile);
        } else if (sourceType == 3) {
            Util.verbose((String)("\tWriting stored Java model code to " + this.javaFile));
            modelSource = modelSource.replaceAll("JSIM__MODEL__CLASS", className);
            UtilIO.writeText((File)this.javaFile, (String)modelSource);
        } else {
            throw new Xcept("Compilation of source type=" + sourceType + " is not supported");
        }
        Util.verbose((String)("\tWriting Java model: " + this.javaFile));
        Util.verbose((String)("==== Compiling Java model " + this.javaFile));
        this.server.javac.compile(this.javaFile, System.err);
        try {
            Class<?> model_class = classLoader.loadClass(className);
            if (!RTModel.class.isAssignableFrom(model_class)) {
                throw new Exception("Class " + className + " does not extend RTModel");
            }
            Class[] argc = new Class[]{UnitNList.class, ASServer.Messenger.class};
            Constructor<?> cons = model_class.getConstructor(argc);
            Object[] args = new Object[]{this.server.sysUnits(), this};
            this.rtmodel = (RTModel)cons.newInstance(args);
            this.rtmodel.setMaxProc(this.maxProc());
            this.rtmodel.setOptimFactory(this.server.optimFactory());
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new Xcept((Throwable)e, "Invocation target error instantiating " + className);
        }
        catch (NoSuchMethodException e) {
            throw new Xcept((Throwable)e, "Class " + className + " must be public and have public CONSTRUCTOR with one argument");
        }
        catch (IllegalAccessException e) {
            throw new Xcept((Throwable)e, "Class " + className + " must be public and have PUBLIC constructor with one argument");
        }
        catch (InstantiationException e) {
            throw new Xcept((Throwable)e, "Error instantiating " + className);
        }
        catch (Throwable e) {
            throw new Xcept(e, "Internal error instantiating " + className + ": " + e);
        }
    }

    public String buildCancelMessage() {
        if (this.cancelBuild) {
            return "user";
        }
        long delta = System.currentTimeMillis() - this.buildStartTime;
        if (this.maxBuildTime > 0 && delta > (long)(this.maxBuildTime * 1000)) {
            return "timeout (" + this.maxBuildTime + " secs)";
        }
        return null;
    }

    private void checkBuilt(String s) throws Xcept {
        if (this.isBuilt()) {
            return;
        }
        throw new Xcept((DiagInfo)this, s + "() called while model not compiled");
    }

    public String diagInfo() {
        return "LSModel " + this.name;
    }

    public final boolean isBuilt() {
        return this.rtmodel != null;
    }

    public ASVar.List getASVars() throws Xcept {
        this.checkBuilt("getASVars");
        return this.rtmodel.getVars();
    }

    public ASVar getASVar(String n) throws Xcept {
        this.checkBuilt("getASVar");
        return this.rtmodel.getVar(n);
    }

    public ASQuery parseQuery(String s) throws Xcept {
        this.checkBuilt("parseQuery");
        try {
            return this.rtmodel.getVar(s);
        }
        catch (Xcept e) {
            return new RTQuery(this.rtmodel, s);
        }
    }

    public Data getData(int i, ASQuery query) throws Xcept {
        this.checkBuilt("getData");
        if (query instanceof RTVar) {
            return this.rtmodel.getData(i, (Expr)((RTVar)query));
        }
        if (query instanceof RTQuery) {
            return this.rtmodel.getData(i, ((RTQuery)query).expr());
        }
        throw new Xcept("LSModel.getData() requires RTQuery");
    }

    public FimData getFimData() {
        if (this.fim == null) {
            return null;
        }
        return this.fim.fimData();
    }

    public UnitNList units() throws Xcept {
        this.checkBuilt("units");
        return this.rtmodel.units;
    }

    public String getText(int type, String variant) throws Xcept {
        try {
            boolean useCache;
            boolean bl = useCache = this.modelTextCache != null && type >= 0 && type < this.modelTextCache.length && Util.isBlank((String)variant);
            if (useCache && this.modelTextCache[type] != null) {
                return this.modelTextCache[type];
            }
            String text = this.getNewText(type, variant);
            if (useCache) {
                this.modelTextCache[type] = text;
            }
            return text;
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    private String getNewText(int type, String variant) throws Exception {
        switch (type) {
            case 7: {
                if (this.plan == null) {
                    throw new Xcept("Plan text not available");
                }
                return this.plan.getPlanText(variant);
            }
            case 9: {
                if (this.flatModel == null) {
                    throw new Xcept("Flat model text not available");
                }
                Document doc = UtilXML.createDoc((String)"html");
                Element html = doc.getDocumentElement();
                html.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                Element body = doc.createElement("body");
                html.appendChild(body);
                MLWriter mwrt = new MLWriter(body);
                mwrt.setParagraphs(true);
                mwrt.add(this.flatModel);
                XMLWriter xwrt = new XMLWriter();
                StringWriter swrt = new StringWriter();
                xwrt.write(doc, (Writer)swrt);
                return swrt.toString();
            }
            case 10: {
                LSPlan xplan = this.plan;
                if (variant != null && variant.equals("sbml")) {
                    xplan = this.sbmlPlan();
                }
                if (xplan == null) {
                    throw new Xcept("Plan XMML text not available");
                }
                return xplan.getXMMLText();
            }
            case 11: {
                if (this.plan == null) {
                    throw new Xcept("Plan GraphML text not available");
                }
                return this.plan.getGraphMLText();
            }
            case 1: {
                if (this.mmlText == null) {
                    throw new Xcept("MML text not available");
                }
                return this.mmlText;
            }
            case 2: {
                if (this.flatFile == null || !this.flatFile.exists()) {
                    throw new Xcept("Flat MML text not available");
                }
                return UtilIO.readText((File)this.flatFile);
            }
            case 3: {
                if (this.javaFile == null || !this.javaFile.exists()) {
                    throw new Xcept("Java text not available");
                }
                return UtilIO.readText((File)this.javaFile);
            }
            case 4: {
                if (!Util.v2) {
                    throw new Xcept("SBML output not available until version 2");
                }
                String xmml = this.getText(10, "sbml");
                return this.server.translateModelText(10, 4, xmml, null);
            }
        }
        throw new Xcept("Unknown getText ID=" + type);
    }

    private LSPlan sbmlPlan() throws Xcept {
        if (this.sbmlPlan != null) {
            return this.sbmlPlan;
        }
        if (this.buildInfo == null) {
            return null;
        }
        if (this.buildInfo.sourceType != 1) {
            return null;
        }
        String src = this.mmlText + "\n";
        if (this.flatFile.exists()) {
            src = UtilIO.readText((File)this.flatFile);
        }
        StringReader rdr = new StringReader(src);
        ModelReader model = new ModelReader(rdr, this.server.classLoader, this.server.jsimPath());
        model.flatten(this.flatFile.getPath());
        MathSys math = model.getFlatMath();
        NamedVal.NList options = new NamedVal.NList(this.buildInfo.options.info());
        options.setVal("makeDEICParms", false);
        this.sbmlPlan = new LSPlan20(model, options);
        this.sbmlPlan.makePlan();
        return this.sbmlPlan;
    }

    public NamedVal.NList getProperties() throws Xcept {
        if (this.props != null) {
            return this.props;
        }
        if (this.flatModel == null) {
            throw new Xcept((DiagInfo)this, "Properties not available");
        }
        MathSys math = this.flatModel.getFlatMath();
        this.props = math.getProperties();
        if (this.plan != null) {
            this.plan.addProperties(this.props);
        }
        return this.props;
    }

    public ASConstraint.List getConstraints() throws Xcept {
        if (this.constraints != null) {
            return this.constraints;
        }
        if (this.flatModel == null) {
            throw new Xcept((DiagInfo)this, "Constraints not available");
        }
        ASConstraint.Info[] info = this.plan != null ? this.plan.getConstraints() : this.flatModel.getFlatMath().getConstraints();
        this.constraints = new ASConstraint.List(info);
        return this.constraints;
    }

    protected int maxProc() {
        int n = this.rtmodel != null && !this.rtmodel.allowMPRuns() ? 1 : this.server.maxProc();
        return n;
    }

    public void singleRun(NamedVal.NList runVals) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 0;
        this.jobStat = new ASInfo.Status(1);
        this.jobStat.mode = 0;
        this.jobStat.nruns = 1;
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(1);
        this.rtmodel.setRunVals(runVals);
        this.rtmodel.run(1, this.maxProc(), 0, null);
    }

    public void loopsRun(ASInfo.Loops loops) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 1;
        this.jobStat = new ASInfo.Status(loops.n());
        this.jobStat.mode = 1;
        this.jobStat.nruns = loops.n();
        this.jobStat.runName = "parallel loops";
        MPDispatch.Job[] jobs = new MPDispatch.Job[loops.n()];
        for (int i = 0; i < loops.n(); ++i) {
            jobs[i] = new SingleRun(loops.runNames[i], i, loops.nvals[i]);
        }
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(loops.runNames);
        this.rtmodel.setRunVals(loops.baseVals);
        MPDispatch dispatch = new MPDispatch("loops", jobs, (MPDispatch.Monitor)this);
        dispatch.run(this.maxProc());
        this.jobStat.nrunsDone = this.jobStat.nruns;
    }

    public synchronized void jobStarted(MPDispatch.Job job) {
        this.jobStat.runName = job.jobName();
    }

    public synchronized void jobCompleted(MPDispatch.Job job) {
        ++this.jobStat.nrunsDone;
    }

    public void sensRun(ASInfo.Sens sens) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 3;
        this.jobStat = new ASInfo.Status(1 + sens.parNames.length);
        this.jobStat.mode = 3;
        this.jobStat.nruns = 1 + sens.parNames.length;
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(sens.parNames, sens.deltas);
        this.rtmodel.setRunVals(sens.baseVals);
        this.jobStat.runName = null;
        this.rtmodel.run(1, 1, 0, null);
        ++this.jobStat.nrunsDone;
        int n = sens.parNames.length;
        MPDispatch.Job[] jobs = new MPDispatch.Job[n];
        for (int i = 0; i < n; ++i) {
            String pname = sens.parNames[i];
            ASQuery q = this.parseQuery(pname);
            Data data = this.getData(0, q);
            double val = data.realVal(0) + sens.deltas[i];
            if (Double.isNaN(val)) {
                throw new Xcept("Sensitivity parameter " + pname + "=NaN");
            }
            NamedVal nval = NamedVal.create((String)pname, (double)val);
            NamedVal.NList nvals = new NamedVal.NList();
            nvals.add((Named)nval);
            jobs[i] = new SingleRun("sens " + pname, i + 1, nvals);
        }
        MPDispatch dispatch = new MPDispatch("sensitivity", jobs, (MPDispatch.Monitor)this);
        dispatch.run(this.maxProc());
        this.jobStat.nrunsDone = this.jobStat.nruns;
    }

    public void optimRun(ASInfo.Optim jinfo) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 2;
        this.jobStat = new ASInfo.Status(2);
        this.jobStat.mode = 2;
        this.jobStat.nruns = 1 + jinfo.args.maxCalls;
        this.optim = null;
        this.optim = new LSModelOptim(this, jinfo, 0, 0);
        int nproc = this.optim.maxProc();
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(1 + nproc);
        this.rtmodel.setRunVals(jinfo.baseVals);
        this.optim.optimize();
    }

    public void fimRun(ASInfo.Fim jinfo) throws Xcept {
        this.fim = null;
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 4;
        this.jobStat = new ASInfo.Status(2);
        this.jobStat.mode = 4;
        this.jobStat.nruns = 1 + jinfo.optim.args.maxCalls;
        this.optim = null;
        int nproc = this.maxProc();
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(2 * nproc);
        this.rtmodel.setRunVals(jinfo.optim.baseVals);
        this.fim = new LSModelFim(this, jinfo, nproc);
        this.fim.run();
    }

    private void checkCompiled() throws Xcept {
        if (this.rtmodel == null) {
            throw new Xcept((DiagInfo)this, "Can't start job.  Model is not compiled.");
        }
    }

    public ASInfo.Status getJobStatus() {
        if (this.jobStat == null) {
            return null;
        }
        if (this.jobStat != null && this.rtmodel != null && this.jobStat.runStats != null) {
            for (int i = 0; i < this.jobStat.runStats.length; ++i) {
                this.jobStat.runStats[i] = this.rtmodel.getRunStat(i);
            }
        }
        return this.jobStat;
    }

    public void cancelJob() {
        this.cancelBuild = true;
        if (this.rtmodel != null) {
            this.rtmodel.cancelRun = true;
        }
    }

    public int storeMode() {
        return this.storeMode;
    }

    public int nstores() {
        if (!this.isBuilt()) {
            return 0;
        }
        return this.rtmodel.nstores();
    }

    public String getStoreName(int i) {
        if (i < 0 || i >= this.nstores()) {
            return null;
        }
        return this.rtmodel.getStoreName(i);
    }

    public OptimResults optimResults() {
        if (this.optim != null) {
            return this.optim.results();
        }
        return null;
    }

    protected LSServer server() {
        return this.server;
    }

    protected RTModel rtmodel() {
        return this.rtmodel;
    }

    protected ASInfo.Build buildInfo() {
        return this.buildInfo;
    }

    public ASModel.Flags getFlags() {
        if (this.rtmodel == null) {
            return new ASModel.Flags();
        }
        return this.rtmodel.getFlags();
    }

    public void setFuncGenNames(String[] names) throws Xcept {
        if (this.isBuilt()) {
            this.rtmodel.setFuncGenNames(names);
        }
    }

    public String modelID() {
        return "lsmodel" + this.hashCode();
    }

    public void message(ASInfo.Message msg) {
        if (this.server.messenger == null) {
            return;
        }
        msg.modelID = this.modelID();
        this.server.messenger.message(msg);
    }

    public class SingleRun
    implements MPDispatch.Job {
        private String jobName;
        private int storeInx;
        private NamedVal.NList nvals;

        public SingleRun(String j, int i, NamedVal.NList n) {
            this.jobName = j;
            this.storeInx = i;
            this.nvals = n;
        }

        public String jobName() {
            return this.jobName;
        }

        public void jobRunX(int workerInx) throws Xcept {
            LSModel.this.rtmodel.run(workerInx + 1, 1, this.storeInx, this.nvals);
        }

        public void jobCancel() {
        }
    }
}

