/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASInfo;
import JSim.aserver.ASQuery;
import JSim.aserver.ASVar;
import JSim.data.Data;
import JSim.data.FimData;
import JSim.lserver.LSModel;
import JSim.lserver.LSModelOptim;
import JSim.util.MPDispatch;
import JSim.util.Xcept;

public class LSModelFim
implements MPDispatch.Monitor {
    private LSModel lsmodel;
    private ASInfo.Fim info;
    private int nproc;
    private ASVar[] parVars;
    private String[] parInitVals;
    private ASQuery[] matchExprs;
    private boolean cancelled;
    private FimData fimData;

    public LSModelFim(LSModel model, ASInfo.Fim fim, int nproc) throws Xcept {
        this.lsmodel = model;
        this.info = fim;
        this.nproc = nproc;
        this.parVars = new ASVar[this.npars()];
        this.parInitVals = new String[this.npars()];
        for (int p = 0; p < this.npars(); ++p) {
            String pname = this.info.optim.args.xname[p];
            this.parVars[p] = this.lsmodel.getASVar(pname);
            this.parInitVals[p] = this.parVars[p].getAssign();
        }
        this.matchExprs = new ASQuery[this.nmatches()];
        for (int m = 0; m < this.nmatches(); ++m) {
            this.matchExprs[m] = this.lsmodel.parseQuery(this.info.optim.matchExprs[m]);
        }
        this.fimData = new FimData(this.info.optim.args.xname, this.nsegments(), this.nmatches());
    }

    public void runSimple() throws Xcept {
        for (int s = 0; s < this.nsegments() && !this.cancelled; ++s) {
            this.runSegment(s, 0);
        }
    }

    public void run() throws Xcept {
        MPDispatch.Job[] jobs = new MPDispatch.Job[this.nsegments()];
        for (int s = 0; s < this.nsegments(); ++s) {
            jobs[s] = new SingleSegment(s);
        }
        MPDispatch dispatch = new MPDispatch("fim", jobs, (MPDispatch.Monitor)this);
        dispatch.run(this.nproc);
    }

    private void runSegment(int s, int threadInxBase) throws Xcept {
        ASInfo.Optim optInfo = this.info.optim.copy();
        optInfo.refData = this.info.refData[s];
        int np = 1;
        LSModelOptim optim = new LSModelOptim(this.lsmodel, optInfo, threadInxBase, np);
        try {
            optim.optimize();
        }
        catch (Exception e) {
            if (!this.info.noabort) {
                throw Xcept.wrap((Throwable)e);
            }
            if (this.info.saveOptimResults) {
                this.fimData.setOptimResults(s, optim.results());
            }
            this.fimData.setDone(s);
            return;
        }
        for (int p = 0; p < this.npars(); ++p) {
            double val = optim.results().bestX[p];
            this.fimData.setFimData(p, s, val);
        }
        for (int m = 0; m < this.nmatches(); ++m) {
            int storeInx = threadInxBase;
            Data data = this.lsmodel.getData(storeInx, this.matchExprs[m]);
            this.fimData.setFitData(s, m, data);
        }
        if (this.info.saveOptimResults) {
            this.fimData.setOptimResults(s, optim.results());
        }
        this.fimData.setDone(s);
    }

    public void cancel() {
        this.cancelled = true;
    }

    public synchronized void jobStarted(MPDispatch.Job job) {
    }

    public synchronized void jobCompleted(MPDispatch.Job job) {
    }

    public int nsegments() {
        return this.info.nsegments();
    }

    public int npars() {
        return this.info.npars();
    }

    public int nmatches() {
        return this.info.nmatches();
    }

    public FimData fimData() {
        return this.fimData;
    }

    public class SingleSegment
    implements MPDispatch.Job {
        private int segment;

        public SingleSegment(int segment) {
            this.segment = segment;
        }

        public void jobRunX(int workerInx) throws Xcept {
            if (LSModelFim.this.cancelled) {
                return;
            }
            int threadBaseInx = workerInx * 2;
            LSModelFim.this.runSegment(this.segment, threadBaseInx);
        }

        public void jobCancel() {
            LSModelFim.this.cancelled = true;
        }

        public String jobName() {
            return "Segment_" + (this.segment + 1);
        }
    }
}

