/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASConstraint;
import JSim.data.NamedVal;
import JSim.data.XMLWriter;
import JSim.jcode.JPlanWriter;
import JSim.lserver.LSModel;
import JSim.lserver.LSPlan;
import JSim.lserver.LSServer;
import JSim.mml.Model;
import JSim.plan.JSPlanWriter;
import JSim.plan.PlanIF;
import JSim.plan.PlanWriter;
import JSim.plan1.Plan;
import JSim.util.Plugin;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;

public class LSPlan16
implements LSPlan {
    private LSModel lsmodel;
    private PlanIF plan;

    public LSPlan16(Model flatModel, LSModel lsmodel) throws Xcept {
        this.lsmodel = lsmodel;
        this.plan = new Plan(flatModel, lsmodel);
    }

    public void makePlan() {
    }

    public void writeJava(String outbase, File javaFile) throws Xcept {
        JPlanWriter pwriter = new JPlanWriter(this.plan, outbase);
        pwriter.setDebug(this.lsmodel.buildInfo());
        Util.verbose((String)("\tWriting Java model: " + javaFile));
        try {
            FileOutputStream jstr = new FileOutputStream(javaFile);
            PrintStream jout = new PrintStream(jstr);
            pwriter.write(jout);
            jstr.close();
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    public String getPlanText(String variant) throws Xcept {
        PlanWriter pwriter = new JSPlanWriter(this.plan);
        if (variant != null) {
            Plugin plugin = this.server().plugins().plugin("PlanWriter", variant);
            if (plugin == null) {
                throw new Xcept("PlanWriter plugin " + variant + " not found");
            }
            pwriter = (PlanWriter)plugin.newInstance(new Class[]{PlanIF.class}, new Object[]{this.plan});
        }
        return pwriter.writeText();
    }

    public String getXMMLText() throws Xcept {
        Document doc = this.plan.getXMML();
        XMLWriter xwrt = new XMLWriter();
        StringWriter swrt = new StringWriter();
        try {
            xwrt.write(doc, (Writer)swrt);
            return swrt.toString();
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    public String getGraphMLText() throws Xcept {
        throw new Xcept("GraphML is not available until JSim version 2");
    }

    public void addProperties(NamedVal.NList props) throws Xcept {
        if (this.plan != null) {
            this.plan.addProperties(props);
        }
    }

    public ASConstraint.Info[] getConstraints() throws Xcept {
        if (this.plan == null) {
            return null;
        }
        return this.plan.getConstraints();
    }

    protected LSServer server() {
        return this.lsmodel.server();
    }
}

