/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASServer;
import JSim.cellml.CMLDoc;
import JSim.data.NamedVal;
import JSim.lserver.LSTranslator;
import JSim.sbml.SBModel;
import JSim.util.StringList;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.StringReader;
import java.io.StringWriter;
import org.w3c.dom.Document;

public class LSTranslator16
implements LSTranslator {
    private ASServer server;
    private int srcType;
    private String srcText;
    private int destType;
    private NamedVal[] options;
    private String destText;
    private StringList warnings;

    public LSTranslator16(ASServer server, int srcType, String srcText) throws Xcept {
        this.server = server;
        this.srcText = srcText;
        this.srcType = srcType;
    }

    public String getText(int destType, NamedVal[] options) throws Xcept {
        this.destType = destType;
        this.options = options;
        this.destText = null;
        this.warnings = new StringList();
        if (destType != 1) {
            throw new Xcept("Translation to non-MML formats not currently supported");
        }
        if (this.srcType != 0 && this.srcType != 4 && this.srcType != 5) {
            throw new Xcept("Translation from non-XML formats not currently supported");
        }
        Document doc = UtilXML.parse((String)this.srcText);
        String type = doc.getDocumentElement().getNodeName();
        StringWriter wrt = new StringWriter();
        if (type.equals("model")) {
            CMLDoc cmlDoc = new CMLDoc(doc, this.server.cellMLUnits(), this.server.sysUnits());
            cmlDoc.writeMML(wrt);
        } else if (type.equals("sbml")) {
            String xtext = this.srcText.replaceAll("\"_", "\"");
            StringReader rdr = new StringReader(xtext);
            SBModel sbmodel = new SBModel(rdr, options);
            sbmodel.writeMML(wrt);
        } else {
            throw new Xcept("Unsupported XML file format:  document element=" + type);
        }
        return ((Object)wrt).toString();
    }

    public StringList getWarnings() {
        return this.warnings;
    }
}

