/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASModel;
import JSim.aserver.ASServer;
import JSim.cellml.CMLDoc;
import JSim.data.NamedVal;
import JSim.lserver.LSTranslator;
import JSim.sbml2.SBMLWriter;
import JSim.sbml2.SBModel;
import JSim.util.StringList;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.StringWriter;
import org.w3c.dom.Document;

public class LSTranslator20
implements LSTranslator {
    private ASServer server;
    private int srcType;
    private String srcText;
    private Document srcDoc;
    private int destType;
    private NamedVal[] options;
    private String destText;
    private StringList warnings;

    public LSTranslator20(ASServer server, int srcType, String srcText) throws Xcept {
        this.server = server;
        this.srcText = srcText;
        this.srcType = srcType;
        if (srcType == 0) {
            this.srcDoc = UtilXML.parse((String)srcText);
            String type = this.srcDoc.getDocumentElement().getNodeName();
            if (type.equals("sbml")) {
                this.srcType = 4;
            } else if (type.equals("model")) {
                this.srcType = 5;
            } else {
                throw new Xcept("Unsupported XML file format:  document element=" + type);
            }
        }
    }

    public String getText(int destType, NamedVal[] options) throws Xcept {
        this.destType = destType;
        this.options = options;
        this.destText = null;
        this.warnings = new StringList();
        if (this.srcType == 4 && destType == 1) {
            return this.sbml2MML();
        }
        if (this.srcType == 5 && destType == 1) {
            return this.cellml2MML();
        }
        if (this.srcType == 10 && destType == 4) {
            return this.xmml2SBML();
        }
        throw new Xcept("Translation from " + ASModel.TEXT_NAMES[this.srcType] + " to " + ASModel.TEXT_NAMES[destType] + " is not yet supported");
    }

    private String sbml2MML() throws Xcept {
        SBModel sbmodel = new SBModel(this.srcText, this.options);
        StringWriter wrt = new StringWriter();
        sbmodel.writeMML(wrt);
        return ((Object)wrt).toString();
    }

    private String cellml2MML() throws Xcept {
        if (this.srcDoc == null) {
            this.srcDoc = UtilXML.parse((String)this.srcText);
        }
        CMLDoc cmlDoc = new CMLDoc(this.srcDoc, this.server.cellMLUnits(), this.server.sysUnits());
        StringWriter wrt = new StringWriter();
        cmlDoc.writeMML(wrt);
        return ((Object)wrt).toString();
    }

    private String xmml2SBML() throws Xcept {
        if (this.srcDoc == null) {
            this.srcDoc = UtilXML.parse((String)this.srcText);
        }
        try {
            SBMLWriter swrt = new SBMLWriter(this.srcDoc, this.warnings);
            return swrt.getSBML();
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    public StringList getWarnings() {
        return this.warnings;
    }
}

