/*
 * Decompiled with CFR 0.152.
 */
package JSim.mathml;

import JSim.mathml.MLNameSpace;
import JSim.util.Expr;
import JSim.util.NameSpace;
import JSim.util.NamedExpr;
import JSim.util.NamedRealConst;
import JSim.util.Unit;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class MLLambda
implements MLNameSpace {
    private NameSpace nsParent;
    private String name;
    private ArrayList<NamedExpr> args;
    private Expr eval;

    public MLLambda(NameSpace ns) {
        this.nsParent = ns;
        this.args = new ArrayList();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addArg(String n) throws Xcept {
        if (this.arg(n) != null) {
            throw new Xcept("Duplicate lambda argument name: " + n);
        }
        this.args.add((NamedExpr)new NamedRealConst(n, 0.0));
    }

    public void setEval(Expr eval) {
        this.eval = eval;
    }

    public int nargs() {
        return this.args.size();
    }

    public NamedExpr arg(int i) {
        return this.args.get(i);
    }

    public NamedExpr arg(String n) {
        for (int i = 0; i < this.args.size(); ++i) {
            if (!this.arg(i).name().equals(n)) continue;
            return this.arg(i);
        }
        return null;
    }

    public Expr.List args() {
        Expr.List list = new Expr.List(this.nargs());
        for (int i = 0; i < this.args.size(); ++i) {
            list.add((Object)this.arg(i));
        }
        return list;
    }

    public Expr eval() {
        return this.eval;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        String f = this.name == null ? "lambda" : this.name;
        return f + this.args + "=" + this.eval;
    }

    public String diagInfo() {
        return "MathML lambda: " + this;
    }

    public Expr compByName(String name) throws Xcept {
        NamedExpr e = this.arg(name);
        if (e == null) {
            e = this.nsParent.compByName(name);
        }
        if (e == null) {
            throw new Xcept("<lambda> can't find variable " + name);
        }
        return e;
    }

    public String compNameByElement(Element e) throws Xcept {
        return UtilXML.getText((Element)e);
    }

    public Expr makeDeriv(Expr e1, Expr e2) throws Xcept {
        return this.nsParent.makeDeriv(e1, e2);
    }

    public Unit unitByName(String name) throws Xcept {
        return this.nsParent.unitByName(name);
    }

    public Expr funcCall(String name, Expr.List elist) throws Xcept {
        return this.nsParent.funcCall(name, elist);
    }
}

