/*
 * Decompiled with CFR 0.152.
 */
package JSim.mathml;

import JSim.mathml.MLCSymbol;
import JSim.mathml.MLMath;
import JSim.mathml.MLNameSpace;
import JSim.util.Expr;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.NamedRealConst;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UtilIO;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.File;
import org.w3c.dom.Element;

public class MLTest
implements MLNameSpace {
    private NamedList exprs = new NamedList();

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Xcept("Usage: MLMath filename");
        }
        File file = new File(args[0]);
        String text = UtilIO.readText((File)file);
        MLMath math = new MLMath(text);
        StringList names = math.getVars();
        names.remove("f1");
        System.out.println("Names=" + names);
        MLCSymbol delay = new MLCSymbol("delay"){

            public Expr makeExpr(Expr.List args) throws Xcept {
                String s = "" + args.expr(0) + "(t-(" + args.expr(1) + "))";
                return new NamedRealConst(s, Double.NaN);
            }
        };
        MLCSymbol.NList csyms = new MLCSymbol.NList();
        csyms.add(delay);
        MLTest test = new MLTest(names);
        Expr.List exprs = math.makeExprList(test, csyms);
        System.out.println("Exprs: " + exprs);
    }

    public MLTest(StringList names) {
        for (int i = 0; i < names.size(); ++i) {
            this.exprs.add((Named)new NamedRealConst(names.str(i), Double.NaN));
        }
    }

    public Expr compByName(String name) throws Xcept {
        return (Expr)this.exprs.getByName(name);
    }

    public String compNameByElement(Element elem) throws Xcept {
        return UtilXML.getText((Element)elem);
    }

    public Expr makeDeriv(Expr e1, Expr e2) throws Xcept {
        throw new Xcept("makeDeriv() not implemented");
    }

    public Unit unitByName(String name) throws Xcept {
        return Unit.scalar();
    }

    public Expr funcCall(String name, Expr.List elist) throws Xcept {
        if (!name.equals("f1")) {
            return null;
        }
        return new NamedRealConst("f1_call" + elist.size(), 0.0);
    }
}

