/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.NativeFunc;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.StringList;
import JSim.util.XFunc;
import JSim.util.XFuncArg;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.ArrayList;

public abstract class CommonFunc
extends XFunc {
    private int dataType;
    protected Par.List pars;
    private int ninputs;
    private StringList pardoms;

    public CommonFunc(String n, int ftype, int dtype, StringList pstr) throws Xcept {
        super(n, ftype);
        this.dataType = dtype;
        this.pars = new Par.List(pstr.size());
        this.pardoms = new StringList(2);
        boolean input = true;
        for (int i = 0; i < pstr.size(); ++i) {
            String p = pstr.str(i);
            if (p == null) {
                if (input) {
                    input = false;
                    continue;
                }
                throw new Xcept((DiagInfo)this, "illegal parameter list");
            }
            Par par = new Par(this, p);
            this.pars.add(par);
            for (int j = 0; j < par.ndim; ++j) {
                this.pardoms.add((Object)par.doms.str(j));
            }
            if (!input) continue;
            ++this.ninputs;
        }
    }

    public abstract void addCode(String var1, String var2) throws Xcept;

    public XFuncCall createCall(Expr.List args) throws Xcept {
        if (args.size() != this.nargs()) {
            throw new Xcept((DiagInfo)this, "requires " + this.nargs() + " arguments");
        }
        XFuncCall fc = new XFuncCall((XFunc)this, args, this.dataType, this.ninputs);
        XFuncArg.List fcargs = fc.args();
        Expr[] fcdoms = new Expr[this.pardoms.size()];
        for (int i = 0; i < this.pars.size(); ++i) {
            Par par = this.pars.par(i);
            XFuncArg fcarg = fcargs.arg(i);
            for (int j = 0; j < par.ndim; ++j) {
                String pardom = par.doms.str(j);
                int inx = this.pardoms.indexOf(pardom);
                if (j >= fcarg.argDoms().size()) {
                    throw new Xcept((DiagInfo)this, "missing domain \"" + pardom + "\" in function call");
                }
                Expr fcargdom = fcarg.argDoms().expr(j);
                if (fcdoms[inx] == null) {
                    fcdoms[inx] = fcargdom;
                }
                if (fcargdom.sameAs(fcdoms[inx])) continue;
                throw new Xcept((DiagInfo)this, "inconsistent domain \"" + pardom + "\" definition in function call");
            }
        }
        return fc;
    }

    public int dataType() {
        return this.dataType;
    }

    public int nargs() {
        return this.pars.size();
    }

    public int ninputs() {
        return this.ninputs;
    }

    public String parName(int i) {
        return this.pars.par((int)i).name;
    }

    public String flatHdr() {
        String hdr = this instanceof NativeFunc ? "native " : "source ";
        hdr = hdr + (this.dataType == 4 ? "real function " : "procedure ");
        hdr = hdr + this.name + " (";
        for (int i = 0; i < this.pars.size(); ++i) {
            if (i == this.ninputs) {
                hdr = hdr + ";";
            } else if (i > 0) {
                hdr = hdr + ",";
            }
            hdr = hdr + this.pars.par((int)i).desc;
        }
        hdr = hdr + ") {";
        return hdr;
    }

    public static class Par {
        public CommonFunc func;
        public String desc;
        public String name;
        public int ndim;
        public StringList doms;

        public Par(CommonFunc f, String d) throws Xcept {
            this.func = f;
            this.name = this.desc = d;
            this.doms = new StringList(2);
            while (this.name.lastIndexOf(64) > 0) {
                int inx = this.name.lastIndexOf(64);
                ++this.ndim;
                String dom = this.name.substring(inx + 1);
                this.doms.add((Object)dom);
                this.name = this.name.substring(0, inx);
            }
            if (this.doms.size() != this.ndim) {
                throw new Xcept((DiagInfo)f, "duplicate @domain in function or procedure declaration");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class List
        extends ArrayList<Par> {
            public List(int n) {
                super(n);
            }

            public Par par(int i) {
                return (Par)this.get(i);
            }
        }
    }
}

