/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.CompProp;
import JSim.mml.Eqn;
import JSim.mml.Event;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.Sys;
import JSim.mml.Templ;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.NamedList;
import JSim.util.NamedQueryExpr;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintStream;

public abstract class Comp
extends NamedExpr {
    public static final String sep = ".";
    public static final char sepchar = '.';
    public static final int PUBLIC = 0;
    public static final int EXTERN = 1;
    public static final int PRIVATE = 2;
    protected Comp parent;
    protected boolean builtin;
    protected Templ templ;
    protected String name;
    protected int access;
    public NList child;
    public CompProp.List props;
    public Eqn.List eqn;
    public Event.List events;
    public Expr.List voidFuncCalls;
    protected Expr.List args;

    public Comp(Comp p, String n, Expr.List e) throws Xcept {
        this.parent = p;
        this.name = n;
        this.args = e;
        this.child = new NList(1);
        this.props = new CompProp.List(2);
        this.eqn = new Eqn.List(1);
        this.events = new Event.List(1);
        this.voidFuncCalls = new Expr.List(1);
        if (this.parent == null) {
            return;
        }
        if (this.parent.getNamed(n) != null) {
            throw new Xcept((DiagInfo)this, "duplicate component or property name");
        }
        Comp.validateName((DiagInfo)this, this.name);
        this.parent.registerChild(this);
        this.builtin = true;
    }

    public static void validateName(DiagInfo dinfo, String n) throws Xcept {
        String s2;
        String msg = "Illegal name \"" + n + "\": ";
        for (int i = 0; i < n.length(); ++i) {
            char c = n.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == ':') continue;
            throw new Xcept(dinfo, msg + "contains illegal character '" + c + "'");
        }
        if (n.length() < 1) {
            throw new Xcept(dinfo, msg + "blank");
        }
        char c1 = n.charAt(0);
        if (!Character.isLetter(c1)) {
            throw new Xcept(dinfo, msg + "must start with letter");
        }
        if (n.length() > 1 && (s2 = n.substring(0, 2).toUpperCase()).equals("JS")) {
            throw new Xcept(dinfo, msg + "names starting with JS are reserved for JSim internal use");
        }
    }

    public void registerChild(Comp c) throws Xcept {
        this.child.add((Named)c);
    }

    public void registerEqn(Eqn e) throws Xcept {
        this.eqn.add(e);
    }

    public void registerEvent(Event e) throws Xcept {
        this.events.add(e);
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.fullName() + sep + this.name;
    }

    public int dataType() {
        return 0;
    }

    public boolean sameAs(Expr ex) {
        return this == ex;
    }

    public Comp getComp() {
        return this;
    }

    public String toString() {
        return this.toString(this.getSys().ctxt);
    }

    public String toString(Context ctxt) {
        return ctxt.newName((Named)this);
    }

    public String diagInfo() {
        String s = this.fullName();
        return "Component " + (s.startsWith("top.") ? s.substring(4) : s);
    }

    public Sys getSys() {
        return this.parent.getSys();
    }

    public Var getVar() {
        return this.isVar() ? (Var)this : null;
    }

    public void addDomains(Expr.List list) {
        Var v = this.getVar();
        if (v != null) {
            v.addDomains(list);
        }
    }

    public void addSubUnits(Unit.List list, UnitNList modelunits) throws Xcept {
        if (this.unit() != null) {
            this.unit().addSubUnits(list, modelunits);
        }
        for (int i = 0; i < this.child.size(); ++i) {
            Comp c = this.child.comp(i);
            c.addSubUnits(list, modelunits);
        }
    }

    public Comp getParent() {
        return this.parent;
    }

    public Comp getChild(String n) {
        if (this.child == null) {
            return null;
        }
        return (Comp)((Object)this.child.getByName(n));
    }

    public NList getChild(Class clss) {
        NList list = new NList(4);
        for (int i = 0; i < this.child.size(); ++i) {
            Comp c = this.child.comp(i);
            if (((Object)((Object)c)).getClass() != clss) continue;
            list.add((Named)c);
        }
        return list;
    }

    public Model getModel() throws Xcept {
        Comp c = this;
        while (c.parent != null) {
            c = c.parent;
        }
        if (c instanceof Model) {
            return (Model)c;
        }
        if (c.templ == null) {
            throw new Xcept((DiagInfo)c, "templ null, cannot getModel() obj=" + ((Object)((Object)c)).hashCode());
        }
        return c.templ.model;
    }

    public MathSys getTopMath() {
        Comp c = this;
        while (c.parent != null && !(c instanceof Model)) {
            c = c.parent;
        }
        if (c instanceof MathSys) {
            return (MathSys)c;
        }
        return null;
    }

    public boolean isPublic() {
        return this.access == 0;
    }

    public boolean isPrivate() {
        return this.access == 2;
    }

    public boolean isExtern() {
        return this.access == 1;
    }

    public boolean isVar() {
        return false;
    }

    public boolean isNVar() {
        return false;
    }

    public boolean hasUnit() {
        return false;
    }

    public void setUnit(Unit u) throws Xcept {
        throw new Xcept((DiagInfo)this, "setUnit() not supported");
    }

    public Unit unit() {
        return null;
    }

    public Expr unitCorrect() {
        return this;
    }

    public Expr calculable(Known known) throws Xcept {
        throw new Xcept((DiagInfo)this, "calculable() not implemented");
    }

    public void setAccess(int a) throws Xcept {
        this.access = a;
    }

    public void addProp(String n, int dtype) throws Xcept {
        if (this.prop(n) != null) {
            throw new Xcept((DiagInfo)this, "duplicate property");
        }
        CompProp p = new CompProp(this, n, dtype);
        this.props.add((Object)p);
    }

    public NamedExpr getNamed(String n) {
        NamedExpr cn;
        String n2;
        String n1;
        Comp c = this.getChild(n);
        if (c != null) {
            return c;
        }
        int inx = n.indexOf(46);
        if (inx >= 0) {
            n1 = n.substring(0, inx);
            n2 = n.substring(inx + 1);
            c = this.getChild(n1);
            if (c != null && (cn = c.getNamed(n2)) != null) {
                return cn;
            }
        }
        if ((inx = n.lastIndexOf(46)) >= 0) {
            n1 = n.substring(0, inx);
            n2 = n.substring(inx + 1);
            c = this.getChild(n1);
            if (c != null && (cn = c.getNamed(n2)) != null) {
                return cn;
            }
        }
        return this.prop(n);
    }

    public CompProp prop(String n) {
        for (int i = 0; i < this.props.size(); ++i) {
            CompProp p = (CompProp)this.props.expr(i);
            if (!p.name().equals(n)) continue;
            return p;
        }
        return null;
    }

    protected void expandChildDerivs() throws Xcept {
        int i;
        for (i = 0; i < this.eqn.size(); ++i) {
            this.eqn.eqn(i).expandDeriv();
        }
        for (i = 0; i < this.events.size(); ++i) {
            this.events.event(i).expandDeriv();
        }
        for (i = 0; i < this.child.size(); ++i) {
            this.child.comp(i).expandChildDerivs();
        }
    }

    public void unitCorrectAll() throws Xcept {
        Object e;
        int i;
        Xcept xcept = null;
        for (i = 0; i < this.eqn.size(); ++i) {
            e = this.eqn.eqn(i);
            Util.verbose((String)("Unit correcting: " + ((Eqn)e).toString()));
            try {
                ((Eqn)e).unitCorrect();
                Util.verbose((String)("             to: " + ((Eqn)e).toString() + "\n"));
                continue;
            }
            catch (Xcept x) {
                if (!Util.verbose) {
                    throw x;
                }
                if (xcept == null) {
                    xcept = x;
                }
                Util.verbose((String)("Unit correction error" + x.getMessage()));
            }
        }
        for (i = 0; i < this.events.size(); ++i) {
            e = this.events.event(i);
            Util.verbose((String)("Unit correcting: " + ((Event)e).toString()));
            try {
                ((Event)e).unitCorrect();
                Util.verbose((String)("             to: " + ((Event)e).toString() + "\n"));
            }
            catch (Xcept x) {
                if (!Util.verbose) {
                    throw x;
                }
                if (xcept == null) {
                    xcept = x;
                }
                Util.verbose((String)("Unit correction error" + x.getMessage()));
            }
            Util.verbose((String)("             to: " + ((Event)e).toString() + "\n"));
        }
        if (xcept != null) {
            throw xcept;
        }
        for (i = 0; i < this.child.size(); ++i) {
            this.child.comp(i).unitCorrectAll();
        }
    }

    public void simplifyAll() throws Xcept {
        int i;
        for (i = 0; i < this.eqn.size(); ++i) {
            this.eqn.eqn(i).simplify();
        }
        for (i = 0; i < this.events.size(); ++i) {
            this.events.event(i).simplify();
        }
        for (i = 0; i < this.child.size(); ++i) {
            this.child.comp(i).simplifyAll();
        }
    }

    public Expr takeDomDeriv(NamedExpr tt) throws Xcept {
        Var t = (Var)tt;
        Var v = this.getVar();
        if (v == null) {
            throw new Xcept((DiagInfo)this, "takeDeriv() not supported for this component");
        }
        if (v == t) {
            return one;
        }
        if (t.ndim() == 1 && !v.hasDomain(t)) {
            return zero;
        }
        return v.deriv(t);
    }

    public Expr expandDeriv() {
        return this;
    }

    public Expr linearFactor(NamedQueryExpr q, boolean keep) throws Xcept {
        if (keep) {
            return this == q ? one : zero;
        }
        return this == q ? zero : this;
    }

    public void writeFlat(PrintStream out, Context ctxt) throws Xcept {
        int i;
        Model m = this.getModel();
        if (!m.realDomainTempl.clss().isInstance((Object)this)) {
            for (i = 0; i < this.child.size(); ++i) {
                this.child.comp(i).writeFlat(out, ctxt);
            }
        }
        for (i = 0; i < this.eqn.size(); ++i) {
            out.println("\t" + this.eqn.eqn(i).toString(ctxt));
        }
    }

    public String accessString() {
        switch (this.access) {
            case 0: {
                return "";
            }
            case 2: {
                return "private ";
            }
            case 1: {
                return "extern ";
            }
        }
        return "";
    }

    public void dump(PrintStream out, String indent) throws Xcept {
        int i;
        Unit u = this.hasUnit() ? this.unit() : null;
        out.println(indent + (this.builtin ? "builtin " : "") + this.accessString() + (this.templ == null ? ((Object)((Object)this)).getClass().getName() : this.templ.name()) + " " + this.name() + (this.args != null ? this.args.toString() : "") + " " + (u != null ? u.name + "=" + u.toString() : ""));
        for (i = 0; i < this.child.size(); ++i) {
            this.child.comp(i).dump(out, indent + "  ");
        }
        for (i = 0; i < this.eqn.size(); ++i) {
            out.println(indent + "  " + this.eqn.eqn(i).toString());
        }
    }

    public static class List
    extends Expr.List {
        public List(int n) {
            super(n);
        }

        public List(Expr e) throws Xcept {
            this(1);
            e.addNamedExpr((Expr.List)this);
        }

        public Comp comp(int i) {
            return (Comp)((Object)this.get(i));
        }
    }

    public static class NList
    extends NamedList {
        public NList(int i) {
            super(i);
        }

        public Comp comp(int i) {
            return (Comp)((Object)this.get(i));
        }

        public Comp comp(String n) {
            return (Comp)((Object)this.getByName(n));
        }
    }
}

