/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.util.BoolConst;
import JSim.util.CompareExpr;
import JSim.util.ConstExpr;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.RealConst;
import JSim.util.StringConst;
import JSim.util.Unit;
import JSim.util.Xcept;

public class CompProp
extends NamedExpr {
    protected Comp comp;
    protected String name;
    protected Expr expr;
    protected int dataType;

    protected CompProp(Comp c, String n, int d) throws Xcept {
        this.comp = c;
        this.name = n;
        this.dataType = d;
    }

    public void setVal(Expr e) throws Xcept {
        if ((e = e.simplify()).dataType() != this.dataType) {
            throw new Xcept((DiagInfo)this, "property requires " + CompProp.dataTypeName((int)this.dataType) + " value");
        }
        if (this.expr != null && !this.expr.sameAs(e)) {
            throw new Xcept((DiagInfo)this, "conflicting values for property");
        }
        this.expr = e;
    }

    public void setStmt(Expr e) throws Xcept {
        if (!(e instanceof CompareExpr)) {
            throw new Xcept((DiagInfo)this, "illegal property usage (equation expected)");
        }
        CompareExpr ce = (CompareExpr)e;
        if (ce.op() != 48) {
            throw new Xcept((DiagInfo)this, "illegal property usage (equals sign expected)");
        }
        if (ce.arg(0) != this) {
            throw new Xcept((DiagInfo)this, "illegal property usage (LHS)");
        }
        this.setVal(ce.arg(1));
    }

    public String name() {
        return this.name;
    }

    public int dataType() {
        return this.dataType;
    }

    public boolean boolVal(Context ctxt) throws Xcept {
        return this.expr.boolVal(ctxt);
    }

    public double realVal(Context ctxt) throws Xcept {
        return this.expr.realVal(ctxt);
    }

    public String stringVal(Context ctxt) throws Xcept {
        if (this.expr == null) {
            return null;
        }
        return this.expr.stringVal(ctxt);
    }

    public boolean isSet() {
        return this.expr != null;
    }

    public String toString() {
        return this.comp.name() + "." + this.name;
    }

    public boolean isConst() {
        return true;
    }

    public String toString(Context ctxt) {
        return this.toString();
    }

    public ConstExpr cons() throws Xcept {
        return this.expr.cons();
    }

    public Expr calculable(Known known) {
        return truex;
    }

    public Expr simplify(Known known) {
        return this;
    }

    public Unit unit() {
        return this.expr != null ? this.expr.unit() : null;
    }

    public boolean sameAs(Expr expr) {
        return expr == this;
    }

    public Expr unitCorrect() {
        return this;
    }

    public void addDomains(Expr.List list) {
    }

    public void addNamedExpr(Expr.List list) {
        list.addUniq((Expr)this);
    }

    public Expr takeDomDeriv(NamedExpr t) {
        return zero;
    }

    public Expr expandDeriv() {
        return this;
    }

    public void setVal(String s) throws Xcept {
        this.setVal((Expr)new StringConst(s));
    }

    public void setVal(boolean b) throws Xcept {
        this.setVal((Expr)new BoolConst(b));
    }

    public void setVal(double d) throws Xcept {
        this.setVal((Expr)new RealConst(d));
    }

    public static class List
    extends Expr.List {
        public List(int n) {
            super(n);
        }

        public CompProp prop(int i) {
            return (CompProp)((Object)this.get(i));
        }
    }
}

