/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.IntNVar;
import JSim.mml.MathSys;
import JSim.mml.RealNVar;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.RealInterval;
import JSim.util.TypedSet;
import JSim.util.Unit;
import JSim.util.Xcept;

public class Domain
extends Var {
    public static final String[] SFXS = new String[]{"min", "max", "ct", "delta"};
    public static final int NAUX = SFXS.length;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int CT = 2;
    public static final int DELTA = 3;
    public RealNVar vmin = new RealNVar(this, "min", null);
    public RealNVar vmax = new RealNVar(this, "max", null);
    public IntNVar vct = new IntNVar(this, "ct", null);
    public RealNVar vdelta = new RealNVar(this, "delta", null);
    public int maxct;
    public boolean setDelta;
    private int domInx;

    public int domInx() {
        return this.domInx;
    }

    public Domain(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        if (e != null && e.size() > 0) {
            throw new Xcept((DiagInfo)this, "domain declaration takes no arguments");
        }
        MathSys topMath = this.getTopMath();
        if (topMath != null) {
            this.domInx = topMath.domains.size();
            topMath.domains.add(this);
        }
    }

    public void setUnit(Unit u) throws Xcept {
        super.setUnit(u);
        if (u != null) {
            this.vmin.setUnit(u);
            this.vmax.setUnit(u);
            this.vdelta.setUnit(u);
        }
    }

    public int ndim() {
        return 1;
    }

    public Domain domain(int i) {
        if (i == 0) {
            return this;
        }
        return null;
    }

    public boolean isDomain() {
        return true;
    }

    public boolean hasDomain(Var v) {
        return v == this;
    }

    public Var vaux(int i) throws Xcept {
        switch (i) {
            case 0: {
                return this.vmin;
            }
            case 1: {
                return this.vmax;
            }
            case 2: {
                return this.vct;
            }
            case 3: {
                return this.vdelta;
            }
        }
        throw new Xcept((DiagInfo)this, "Illegal vaux() index: " + i);
    }

    public int auxInx(Var v) throws Xcept {
        if (v.parent != this) {
            throw new Xcept((DiagInfo)v, "Variable not a control for domain " + (Object)((Object)this));
        }
        for (int i = 0; i < SFXS.length; ++i) {
            if (!v.name().equals(SFXS[i])) continue;
            return i;
        }
        throw new Xcept((DiagInfo)v, "Variable is not a control for domain " + (Object)((Object)this));
    }

    public SubDom lhbc() throws Xcept {
        return new SubDom(this.eq((Expr)this.vmin));
    }

    public SubDom rhbc() throws Xcept {
        return new SubDom(this.eq((Expr)this.vmax));
    }

    public TypedSet lhbSet() throws Xcept {
        return new RealInterval((Expr)this.vmin, (Expr)this.vmin, true, true);
    }

    public TypedSet rhbSet() throws Xcept {
        return new RealInterval((Expr)this.vmax, (Expr)this.vmax, true, true);
    }

    public Expr lhbExpr() throws Xcept {
        return this.eq((Expr)this.vmin);
    }

    public Expr rhbExpr() throws Xcept {
        return this.eq((Expr)this.vmax);
    }

    public Expr calculable(Known known) throws Xcept {
        TypedSet s = known.getSet((NamedExpr)this);
        return s.isEmpty().not();
    }

    public static class List
    extends Var.List {
        public List(int n) {
            super(n);
        }

        public List(Expr e) throws Xcept {
            this(1);
            e.addDomains((Expr.List)this);
        }

        public Domain domain(int i) {
            return (Domain)this.var(i);
        }
    }
}

