/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.aserver.ASConstraint;
import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.util.CompareExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.Unit;
import JSim.util.UnitXcept;
import JSim.util.Xcept;
import java.util.ArrayList;

public class Event
implements DiagInfo {
    private Comp parent;
    private Expr trigger;
    private Domain t;
    private Var.List vstate;
    private Var.List vaction;
    private Expr.List vexpr;
    private String id;

    public Event(Comp p, Expr trig) throws Xcept {
        this.parent = p;
        this.trigger = trig.simplify();
        if (this.trigger.dataType() != 2) {
            throw new Xcept((DiagInfo)this, "event trigger must be boolean expression");
        }
        this.vstate = new Var.List(4);
        this.vaction = new Var.List(4);
        this.vexpr = new Expr.List(4);
        Domain.List doms = new Domain.List(4);
        this.trigger.addDomains((Expr.List)doms);
        if (doms.size() > 1) {
            throw new Xcept("Event trigger (" + this.trigger + ") may not be multi-dimensional");
        }
        this.t = doms.domain(0);
        this.parent.registerEvent(this);
        this.id = "event-" + this.parent.events.size();
    }

    public void addEqn(Expr eqn) throws Xcept {
        Var v;
        CompareExpr ce;
        block6: {
            block5: {
                CompareExpr compareExpr = ce = eqn instanceof CompareExpr ? (CompareExpr)eqn : null;
                if (ce == null) break block5;
                if (ce.op() == 48) break block6;
            }
            throw new Xcept((DiagInfo)eqn, "event action must be of form variable = expression");
        }
        Var var = v = ce.arg(0) instanceof Var ? (Var)ce.arg(0) : null;
        if (v == null) {
            throw new Xcept((DiagInfo)eqn, "event action LHS missing");
        }
        Domain.List vdoms = new Domain.List(v.ndim());
        v.addDomains(vdoms);
        Domain.List edoms = new Domain.List(v.ndim());
        ce.arg(1).addDomains((Expr.List)edoms);
        if (!vdoms.containSet(edoms)) {
            throw new Xcept((DiagInfo)eqn, "event action RHS has domains missing from LHS");
        }
        this.vstate.addUniq((Expr)v);
        this.vaction.add((Object)v);
        this.vexpr.add((Object)ce.arg(1));
    }

    protected void expandDeriv() throws Xcept {
        this.trigger = this.trigger.expandDeriv();
        Expr.List nexpr = new Expr.List(this.vexpr.size());
        for (int i = 0; i < this.nactions(); ++i) {
            Var v = this.v(i);
            Expr rhs = this.vexpr(i).expandDeriv();
            nexpr.add((Object)rhs);
        }
        this.vexpr = nexpr;
    }

    public void unitCorrect() throws Xcept {
        this.trigger = this.trigger.unitCorrect();
        Expr.List nexpr = new Expr.List(this.vexpr.size());
        for (int i = 0; i < this.nactions(); ++i) {
            Unit ru;
            Var v = this.v(i);
            Expr rhs = this.vexpr(i).unitCorrect();
            Unit lu = v.unit();
            if (!Unit.compatible((Unit)lu, (Unit)(ru = rhs.unit()))) {
                throw new UnitXcept((IExpr)v.eq(rhs), (Expr)v, rhs, lu, ru);
            }
            rhs = rhs.multUnit(lu, ru).simplify();
            nexpr.add((Object)rhs);
        }
        this.vexpr = nexpr;
    }

    public void simplify() throws Xcept {
        this.trigger = this.trigger.simplify();
        Expr.List nexpr = new Expr.List(this.vexpr.size());
        for (int i = 0; i < this.nactions(); ++i) {
            Var v = this.v(i);
            Expr rhs = this.vexpr(i).simplify();
            nexpr.add((Object)rhs);
        }
        this.vexpr = nexpr;
    }

    public ASConstraint.EventInfo constraintInfo() throws Xcept {
        ASConstraint.EventInfo einfo = new ASConstraint.EventInfo();
        einfo.trigger = this.trigger().toString();
        einfo.actions = new ASConstraint.EqnInfo[this.nactions()];
        einfo.vout = this.vstate.stringList().array();
        Expr.List evall = new Expr.List();
        for (int i = 0; i < this.nactions(); ++i) {
            ASConstraint.EqnInfo ainfo = new ASConstraint.EqnInfo();
            Var v = this.v(i);
            Expr eqx = v.eq(this.vexpr(i));
            ainfo.expr = eqx.toString();
            Expr.List vall = new Expr.List();
            eqx.addNamedExpr(vall);
            eqx.addNamedExpr(evall);
            ainfo.vall = vall.stringList().array();
            ainfo.vout = new String[]{v.toString()};
            einfo.actions[i] = ainfo;
        }
        einfo.vall = evall.stringList().array();
        return einfo;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("if (" + this.trigger + ") {");
        for (int i = 0; i < this.nactions(); ++i) {
            buf.append(" " + (Object)((Object)this.v(i)) + "=" + this.vexpr(i));
        }
        return buf.toString() + " }";
    }

    public Var.List vstate() {
        return this.vstate;
    }

    public Expr trigger() {
        return this.trigger;
    }

    public int nactions() {
        return this.vaction.size();
    }

    public Var v(int i) {
        return this.vaction.var(i);
    }

    public Expr vexpr(int i) {
        return this.vexpr.expr(i);
    }

    public String diagInfo() {
        return this.toString();
    }

    public Domain t() {
        return this.t;
    }

    public String id() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<Event> {
        public List(int n) {
            super(n);
        }

        public Event event(int i) {
            return (Event)this.get(i);
        }

        public Var.List vstate() {
            Var.List list = new Var.List(4);
            for (int i = 0; i < this.size(); ++i) {
                Event e = this.event(i);
                list.addUniq(e.vstate());
            }
            return list;
        }
    }
}

