/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.IntegralIF;
import JSim.mml.Range;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.ForallExpr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class Integral
extends Expr
implements IntegralIF {
    private Comp comp;
    private Domain t;
    private Expr min;
    private Expr max;
    private Expr u;
    private Domain.List domains;
    private Var v;
    private Var vf;
    private Expr eval;
    public static final String SINTEGRAL = "integral";

    public Integral(Comp c, Expr expr) throws Xcept {
        this.comp = c;
        if (!(expr instanceof ForallExpr)) {
            throw new Xcept("integral missing @ or range");
        }
        ForallExpr fexpr = (ForallExpr)expr;
        if (!(fexpr.domain() instanceof Domain)) {
            throw new Xcept((DiagInfo)fexpr, "integral must be over domain");
        }
        this.t = (Domain)fexpr.domain();
        this.min = this.t.vmin;
        this.max = this.t.vmax;
        this.u = fexpr.base();
        this.common();
    }

    public Integral(Comp c, Range r, Expr uu) throws Xcept {
        this.comp = c;
        Comp ct = c.getChild(r.t);
        if (!(ct instanceof Domain)) {
            throw new Xcept("Invalid integral domain: " + r.t);
        }
        this.t = (Domain)ct;
        this.min = r.min;
        this.max = r.max;
        this.u = uu;
        this.common();
    }

    private void common() throws Xcept {
        if (this.u instanceof ForallExpr) {
            throw new Xcept("integral does not support nested @'s");
        }
        this.domains = new Domain.List(2);
        this.u.addDomains((Expr.List)this.domains);
        this.domains.sub((Expr)this.t);
        this.min.addDomains((Expr.List)this.domains);
        this.max.addDomains((Expr.List)this.domains);
        if (this.domains.containSame((Expr)this.t)) {
            this.domains.sub((Expr)this.t);
            this.domains.add((Object)this.t);
        }
        Domain.List vdoms = new Domain.List(2);
        vdoms.addUniq(this.domains);
        vdoms.addUniq((Expr)this.t);
        String vname = "integral__call" + this.comp.getModel().newScratch();
        this.v = new RealNVar(this.comp, vname, vdoms);
        this.v.setAccess(2);
        new Eqn(this.comp, this.t.eq((Expr)this.t.vmin), (Expr)this.v, 48, (Expr)zero);
        new Eqn(this.comp, null, (Expr)this.v.deriv(this.t), 48, this.u);
        if (this.max == this.t.vmax || this.min == this.t.vmax) {
            String vfname = vname + "f";
            this.vf = new RealNVar(this.comp, vfname, this.domains);
            this.vf.setAccess(2);
            new Eqn(this.comp, this.t.eq((Expr)this.t.vmax), (Expr)this.vf, 48, (Expr)this.v);
        }
        this.eval = this.vquery(this.max).sub(this.vquery(this.min));
        this.eval = this.eval.simplify();
    }

    private Expr vquery(Expr tval) throws Xcept {
        if (tval == this.t) {
            return this.v;
        }
        if (tval == this.t.vmax) {
            return this.vf;
        }
        if (tval == this.t.vmin) {
            return zero;
        }
        Expr.List args = new Expr.List(this.domains.size());
        args.addUniq((Expr.List)this.domains);
        if (args.containSame((Expr)this.t)) {
            args.sub((Expr)this.t);
        }
        args.add((Object)tval);
        return new VarFuncCall(this.v, args);
    }

    public int dataType() {
        return 4;
    }

    public Domain t() {
        return this.t;
    }

    public Expr min() {
        return this.min;
    }

    public Expr max() {
        return this.max;
    }

    public Expr u() {
        return this.u;
    }

    public boolean sameAs(Expr e) {
        if (!(e instanceof Integral)) {
            return false;
        }
        Integral ei = (Integral)e;
        return this.t.sameAs((Expr)ei.t) && this.min.sameAs(ei.min) && this.max.sameAs(ei.max) && this.u.sameAs(ei.u);
    }

    public void addNamedExpr(Expr.List list) throws Xcept {
        this.t.addNamedExpr(list);
        this.min.addNamedExpr(list);
        this.max.addNamedExpr(list);
        this.u.addNamedExpr(list);
    }

    public void addDomains(Expr.List list) {
        list.addUniq((Expr.List)this.domains);
    }

    public boolean hasUnit() {
        return true;
    }

    public Unit unit() {
        return this.v.unit;
    }

    public Expr unitCorrect() throws Xcept {
        this.min = this.min.unitCorrect();
        this.max = this.max.unitCorrect();
        this.u = this.u.unitCorrect();
        return this;
    }

    public Expr expandDeriv() throws Xcept {
        return this;
    }

    public Expr takeDomDeriv(NamedExpr t) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDomDeriv not implemented");
    }

    public Expr calculable(Known known) throws Xcept {
        return this.eval.calculable(known);
    }

    public Expr simplify(Known known) throws Xcept {
        return this;
    }

    public String toString() {
        return "integral(" + (Object)((Object)this.t) + "," + this.min + "," + this.max + "," + this.u + ")";
    }

    public String toString(Context ctxt) {
        return this.eval.toString(ctxt);
    }

    public Expr evalExpr() {
        return this.eval;
    }
}

