/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.IntegralIF;
import JSim.mml.Model;
import JSim.mml.Range;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.ForallExpr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class IntegralAt
extends Expr
implements IntegralIF {
    private Comp comp;
    private Domain t;
    private Expr min;
    private Expr max;
    private Expr u;
    private Domain.List domains;
    private Var v;
    public static final String SINTEGRAL = "integral";

    public IntegralAt(Comp c, Expr expr) throws Xcept {
        this.comp = c;
        if (!(expr instanceof ForallExpr)) {
            throw new Xcept("integral missing @");
        }
        ForallExpr fexpr = (ForallExpr)expr;
        if (!(fexpr.domain() instanceof Domain)) {
            throw new Xcept((DiagInfo)fexpr, "integral must be over domain");
        }
        this.t = (Domain)fexpr.domain();
        this.min = this.t.vmin;
        this.max = this.t.vmax;
        this.u = fexpr.base();
        this.common();
    }

    public IntegralAt(Comp c, Range r, Expr uu) throws Xcept {
        this.comp = c;
        Comp ct = c.getChild(r.t);
        if (!(ct instanceof Domain)) {
            throw new Xcept("Invalid integral domain: " + r.t);
        }
        this.t = (Domain)ct;
        this.min = r.min;
        this.max = r.max;
        this.u = uu;
        this.common();
    }

    private void common() throws Xcept {
        if (this.u instanceof ForallExpr) {
            throw new Xcept("integral does not support nested @'s");
        }
        this.domains = new Domain.List(2);
        this.u.addDomains((Expr.List)this.domains);
        this.domains.sub((Expr)this.t);
        this.min.addDomains((Expr.List)this.domains);
        this.max.addDomains((Expr.List)this.domains);
        if (this.domains.containSame((Expr)this.t)) {
            this.domains.sub((Expr)this.t);
            this.domains.add((Object)this.t);
        }
        String vname = "integral__call" + this.comp.getModel().newScratch();
        this.v = new RealNVar(this.comp, vname, this.domains);
        this.v.setAccess(2);
        Model model = this.comp.getModel();
        Expr.List args = new Expr.List(1);
        if (this.isAtForm()) {
            args.add((Object)new ForallExpr(this.u, (Expr)this.t));
        } else {
            args.add((Object)new ForallExpr(this.u, (Expr)this.t));
            args.add((Object)this.min);
            args.add((Object)this.max);
        }
        Expr xint = model.funcCall(this.comp, SINTEGRAL, args);
        new Eqn(this.comp, null, (Expr)this.v, 48, xint);
    }

    public int dataType() {
        return 4;
    }

    public Domain t() {
        return this.t;
    }

    public Expr min() {
        return this.min;
    }

    public Expr max() {
        return this.max;
    }

    public Expr u() {
        return this.u;
    }

    public boolean isAtForm() {
        return this.min == this.t.vmin && this.max == this.t.vmax;
    }

    public boolean sameAs(Expr e) {
        if (!(e instanceof IntegralAt)) {
            return false;
        }
        IntegralAt ei = (IntegralAt)e;
        return this.t.sameAs((Expr)ei.t) && this.min.sameAs(ei.min) && this.max.sameAs(ei.max) && this.u.sameAs(ei.u);
    }

    public void addNamedExpr(Expr.List list) throws Xcept {
        this.t.addNamedExpr(list);
        this.min.addNamedExpr(list);
        this.max.addNamedExpr(list);
        this.u.addNamedExpr(list);
    }

    public void addDomains(Expr.List list) {
        list.addUniq((Expr.List)this.domains);
    }

    public boolean hasUnit() {
        return true;
    }

    public Unit unit() {
        if (this.v.unit() != null) {
            return this.v.unit();
        }
        if (this.t.unit() == null || this.u.unit() == null) {
            return null;
        }
        try {
            Unit unit = this.u.unit().mult(this.t.unit());
            this.v.setUnit(unit);
            return unit;
        }
        catch (Xcept e) {
            return null;
        }
    }

    public Expr unitCorrect() throws Xcept {
        this.min = this.min.unitCorrect();
        this.max = this.max.unitCorrect();
        this.u = this.u.unitCorrect();
        if (this.u.unit() != null && this.t.unit() != null) {
            try {
                Unit unit = this.u.unit().mult(this.t.unit());
                this.v.setUnit(unit);
            }
            catch (Xcept xcept) {
                // empty catch block
            }
        }
        return this;
    }

    public Expr expandDeriv() throws Xcept {
        return this;
    }

    public Expr takeDomDeriv(NamedExpr t) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDomDeriv not implemented");
    }

    public Expr calculable(Known known) throws Xcept {
        return this.v.calculable(known);
    }

    public Expr simplify(Known known) throws Xcept {
        return this;
    }

    public String toString() {
        return "integral(" + this.u + "@" + (Object)((Object)this.t) + ")";
    }

    public String toString(Context ctxt) {
        return this.v.toString(ctxt);
    }

    public Expr evalExpr() {
        return this.v;
    }
}

