/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Model;
import JSim.mml.Templ;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class JavaTempl
extends Templ {
    protected Class clss;
    protected Constructor con;

    public JavaTempl(Model m, String n, String cname) throws Xcept {
        super(m, n);
        try {
            this.clss = Class.forName(cname);
        }
        catch (ClassNotFoundException e) {
            throw new Xcept((DiagInfo)this, "Class not found: " + cname);
        }
        Class[] args = new Class[]{Comp.class, String.class, Expr.List.class};
        try {
            this.con = this.clss.getConstructor(args);
        }
        catch (Exception e) {
            throw new Xcept("No appropriate java constructor found for " + this.clss.getName());
        }
    }

    public Class clss() {
        return this.clss;
    }

    public boolean isCompatible(Templ t) throws Xcept {
        if (!JavaTempl.class.isInstance(t)) {
            return false;
        }
        JavaTempl jt = (JavaTempl)t;
        return jt.clss == this.clss;
    }

    public Templ clone(Model m) throws Xcept {
        m.registerTempl(this);
        return this;
    }

    public void dump(PrintStream out, String indent) throws Xcept {
        out.println(indent + "java template " + this.name + " class=" + this.clss.getName());
    }

    public Comp createComp(Comp p, String n, Expr.List args) throws Xcept {
        if (this.con == null) {
            throw new Xcept((DiagInfo)this, "Cannot find child component java constructor");
        }
        Object[] obj = new Object[]{p, n, args};
        try {
            Comp c = (Comp)((Object)this.con.newInstance(obj));
            c.templ = this;
            return c;
        }
        catch (InvocationTargetException e) {
            throw (Xcept)e.getTargetException();
        }
        catch (Exception e) {
            throw new Xcept("Error instantiating " + this.clss.getName() + ": " + e.toString());
        }
    }
}

