/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Domain;
import JSim.util.CompareExpr;
import JSim.util.Context;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;
import java.util.ArrayList;

public class SubDom {
    private static SubDom entire = new SubDom((Expr)Expr.truex);
    public Expr expr;

    public static SubDom entire() {
        return entire;
    }

    public SubDom(Expr e) {
        this.expr = e == null ? Expr.truex : e;
    }

    public Unit unit() {
        return this.expr.unit();
    }

    public SubDom unitCorrect() throws Xcept {
        return new SubDom(this.expr.unitCorrect());
    }

    public boolean isEntire() {
        return this.expr == Expr.truex;
    }

    public boolean sameAs(SubDom sd) {
        return this.expr.sameAs(sd.expr);
    }

    public Domain bcDomain() {
        if (!CompareExpr.class.isInstance(this.expr)) {
            return null;
        }
        CompareExpr rexpr = (CompareExpr)this.expr;
        Expr e = rexpr.arg(0);
        if (e.isDomain()) {
            return (Domain)e;
        }
        e = rexpr.arg(1);
        if (e.isDomain()) {
            return (Domain)e;
        }
        return null;
    }

    public boolean isLHBC() {
        Domain x = this.bcDomain();
        if (x == null) {
            return false;
        }
        CompareExpr rexpr = (CompareExpr)this.expr;
        if (rexpr.op() != 48) {
            return false;
        }
        if (rexpr.arg(0) == x.vmin) {
            return true;
        }
        return rexpr.arg(1) == x.vmin;
    }

    public boolean isRHBC() {
        Domain x = this.bcDomain();
        if (x == null) {
            return false;
        }
        CompareExpr rexpr = (CompareExpr)this.expr;
        if (rexpr.op() != 48) {
            return false;
        }
        if (rexpr.arg(0) == x.vmax) {
            return true;
        }
        return rexpr.arg(1) == x.vmax;
    }

    public boolean isLHBC(Domain x) {
        return x == this.bcDomain() && this.isLHBC();
    }

    public boolean isRHBC(Domain x) {
        return x == this.bcDomain() && this.isRHBC();
    }

    public boolean isBC(Domain x) {
        return this.isLHBC(x) || this.isRHBC(x);
    }

    public String toString() {
        return this.expr.toString();
    }

    public String toString(Context ctxt) {
        return this.expr.toString(ctxt);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<SubDom> {
        public List(int n) {
            super(n);
        }

        public SubDom sdom(int i) {
            return (SubDom)this.get(i);
        }

        public boolean containsSame(SubDom sd) {
            for (int i = 0; i < this.size(); ++i) {
                SubDom s = this.sdom(i);
                if (!sd.sameAs(s)) continue;
                return true;
            }
            return false;
        }
    }
}

