/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.Event;
import JSim.mml.MathSys;
import JSim.mml.RealNVar;
import JSim.mml.Var;
import JSim.mml.VarSet;
import JSim.util.Algebra;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.NamedExpr;
import JSim.util.PrettyUnit;
import JSim.util.RealConst;
import JSim.util.Unit;
import JSim.util.UnitCast;
import JSim.util.Util;
import JSim.util.Xcept;

public class UnitAssignor
implements DiagInfo {
    private VarSet vars;
    private boolean working;
    private DiagInfo wdiag;
    private boolean nullToScalar;

    public UnitAssignor(MathSys math) throws Xcept {
        this.vars = new VarSet(math);
        for (int i = 0; i < math.nVar(); ++i) {
            Var v = math.var(i);
            if (!(v instanceof RealNVar) || v.unit() != null) continue;
            this.vars.add(v);
        }
        if (this.vars.size() == 0) {
            return;
        }
        this.nullToScalar = false;
        this.process(math);
        this.nullToScalar = true;
        this.process(math);
    }

    private void process(MathSys math) throws Xcept {
        this.working = true;
        block0: while (this.working) {
            int i;
            this.working = false;
            for (i = 0; i < math.eqn.size(); ++i) {
                Eqn eqn = math.eqn.eqn(i);
                this.process(eqn.sdom.expr, eqn);
                this.process(eqn.lhs.eq(eqn.rhs), eqn);
                if (this.vars.size() == 0) break;
            }
            for (i = 0; i < math.events.size(); ++i) {
                Event event = math.events.event(i);
                this.process(event.trigger(), event);
                for (int j = 0; j < event.nactions(); ++j) {
                    Expr e = event.v(j).eq(event.vexpr(j));
                    this.process(e, event);
                }
                if (this.vars.size() == 0) continue block0;
            }
        }
    }

    private void process(Expr base, DiagInfo diag) throws Xcept {
        this.wdiag = diag;
        Var.List vs = this.nullUnitVars(base);
        if (vs.size() == 0) {
            return;
        }
        this.debug("base=" + base);
        this.process(base);
    }

    private void process(Expr base) throws Xcept {
        if (this.wdiag == null) {
            return;
        }
        if (base instanceof IExpr) {
            this.process((IExpr)base);
        }
        if (base instanceof UnitCast) {
            UnitCast cast = (UnitCast)base;
            RealConst one = new RealConst(1.0, Unit.scalar());
            this.processEqn(cast.expr(), (Expr)one, (DiagInfo)cast);
        }
    }

    private void process(IExpr base) throws Xcept {
        this.debug("  process " + base);
        for (int i = 0; i < base.nargs(); ++i) {
            this.process(base.arg(i));
        }
        switch (base.op()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: {
                this.processDimless(base.arg(0), (DiagInfo)base);
                break;
            }
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                if (base.arg(0).dataType() != 4) break;
                this.processEqn(base.arg(0), base.arg(1), (DiagInfo)base);
                break;
            }
        }
    }

    private void processDimless(Expr expr, DiagInfo diag) throws Xcept {
        this.debug("    processDimless " + expr);
        RealConst one = new RealConst(1.0, Unit.scalar());
        this.processEqn(expr, (Expr)one, diag);
    }

    private void processEqn(Expr lhs, Expr rhs, DiagInfo diag) throws Xcept {
        Expr expr = lhs.eq(rhs);
        Var.List vs = this.nullUnitVars(expr);
        this.debug("      processEqn" + (Object)((Object)vs) + " " + expr);
        if (vs.size() != 1) {
            return;
        }
        Var v = vs.var(0);
        try {
            Expr vexpr = Algebra.solveUnit((NamedExpr)v, (Expr)lhs, (Expr)rhs);
            this.debug("       orig vexpr=" + vexpr);
            vexpr = vexpr.unitCorrect();
            this.debug("       corrected vexpr=" + vexpr);
            Unit u = vexpr.unit();
            if (u == null) {
                if (!this.nullToScalar) {
                    return;
                }
                u = Unit.scalar();
            }
            this.assign(v, u, diag);
        }
        catch (Xcept e) {
            // empty catch block
        }
    }

    private void assign(Var v, Unit u, DiagInfo diag) throws Xcept {
        while (v.isDeriv()) {
            Domain x = v.derivDomain();
            v = v.unDeriv();
            if (x.unit() == null) continue;
            u = u.mult(x.unit());
        }
        this.assign1(v, u, diag);
        this.wdiag = null;
    }

    private void assign1(Var v, Unit u, DiagInfo diag) throws Xcept {
        if (Unit.compatible((Unit)u, (Unit)Unit.scalar())) {
            u = Unit.scalar();
        }
        u = PrettyUnit.unit((Unit)u);
        Util.verbose((String)("\tAssign " + (Object)((Object)v) + " unit=" + u.pubName() + " via " + diag));
        v.setUnit(u);
        this.vars.sub(v);
        this.working = true;
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            try {
                Var vx = v.deriv(x, false);
                if (vx == null) continue;
                Unit ux = x.unit() == null ? u : u.div(x.unit());
                this.assign1(vx, ux, diag);
                continue;
            }
            catch (Xcept e) {
                // empty catch block
            }
        }
    }

    private Var.List nullUnitVars(Expr expr) throws Xcept {
        Comp.List list = new Comp.List(8);
        expr.addNamedExpr((Expr.List)list);
        Var.List vars = new Var.List(list.size());
        for (int i = 0; i < list.size(); ++i) {
            RealNVar v;
            if (!(list.comp(i) instanceof RealNVar) || (v = (RealNVar)list.comp(i)).unit() != null) continue;
            vars.add((Object)v);
        }
        return vars;
    }

    public String diagInfo() {
        return "Model unit corrector";
    }

    private void debug(String s) {
    }
}

