/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.ModelReader;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

public class UnitNames {
    private UnitNList units;
    private Hashtable<String, Unit> nameMap;
    private Hashtable<Dims, Unit> dimMap;

    public UnitNames() throws Exception {
        File f = new File(Util.jsimHome());
        f = new File(f, "common");
        f = new File(f, UnitNames.canonicalFile() + ".mod");
        ModelReader rdr = new ModelReader(f, null, null);
        this.units = rdr.units;
        this.initMaps();
    }

    public UnitNames(UnitNList units) throws Exception {
        this.units = units;
        this.initMaps();
    }

    private void initMaps() throws Xcept {
        this.nameMap = new Hashtable();
        this.dimMap = new Hashtable();
        ArrayList ulist = new ArrayList();
        for (int i = 0; i < this.units.size(); ++i) {
            Unit u = this.units.unit(i);
            Dims d = new Dims(u);
            Unit u0 = this.dimMap.get(d);
            if (u0 != null && u.name.length() >= u0.name.length()) continue;
            this.dimMap.put(d, u);
        }
    }

    public static String canonicalFile() {
        return "nsrunit";
    }

    public String canonicalName(String n) {
        Unit u;
        try {
            u = this.units.byName(n);
        }
        catch (Xcept e) {
            return null;
        }
        if (u == null) {
            return null;
        }
        Unit un = this.nameMap.get(n);
        if (un != null) {
            return un.name;
        }
        Dims dims = new Dims(u);
        Unit u0 = this.dimMap.get(dims);
        if (u0 == null) {
            this.nameMap.put(u.name, u);
        } else {
            u = u0;
        }
        return u.name;
    }

    public static void main(String[] args) throws Exception {
        UnitNames names = new UnitNames();
        for (int i = 0; i < args.length; ++i) {
            String oldName = args[i];
            String newName = names.canonicalName(oldName);
            System.out.println(oldName + " => " + newName);
        }
    }

    public static class Dims {
        public Unit unit;
        public int hashCode;
        private static final int DK = 4;

        public Dims(Unit u) {
            this.unit = u;
            this.hashCode = 0;
            int ndim = u.dim == null ? 0 : u.dim.length;
            for (int i = 0; i < ndim; ++i) {
                int dh;
                String dhs = "" + u.dim[i];
                dhs = dhs.substring(0, 1);
                try {
                    dh = Util.toInt((String)dhs);
                }
                catch (Xcept e) {
                    dh = 0;
                }
                if (dh > 4) {
                    dh = 4;
                }
                if (dh < -4) {
                    dh = -4;
                }
                this.hashCode *= 8;
                this.hashCode += 4 + dh;
            }
            int df = (int)Math.log10(u.f);
            this.hashCode *= 100;
            this.hashCode += 50 + df;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.unit.toString();
        }

        public String name() {
            return this.unit.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Dims)) {
                return false;
            }
            Dims dims = (Dims)o;
            return Unit.same((Unit)this.unit, (Unit)dims.unit);
        }
    }
}

