/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.NamedQueryExpr;
import JSim.util.TypedSet;
import JSim.util.Unit;
import JSim.util.VectorExpr;
import JSim.util.Xcept;

public class VarFuncCall
extends NamedQueryExpr {
    public Var v;
    public Expr.List args;
    private boolean unitCorrected;

    public VarFuncCall(Var vv, Expr.List a) throws Xcept {
        this.v = vv;
        this.args = a;
        if (this.args.size() == 0) {
            throw new Xcept((DiagInfo)this, "Variable function call requires 1 or more arguments");
        }
        if (this.v.ndim() != this.args.size()) {
            throw new Xcept((DiagInfo)this, "Variable requires " + this.v.ndim() + " arguments");
        }
        this.unitCorrected = false;
    }

    public Expr replace(Expr.List list1, Expr.List list2) throws Xcept {
        Expr.List nargs = new Expr.List(this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            nargs.add((Object)((Expr)this.args.get(i)).replace(list1, list2));
        }
        return new VarFuncCall(this.v, nargs);
    }

    public int dataType() {
        return 4;
    }

    public boolean sameAs(Expr e) {
        VarFuncCall func = null;
        try {
            func = (VarFuncCall)e;
        }
        catch (ClassCastException x) {
            return false;
        }
        return this.v.sameAs((Expr)func.v) && this.args.sameAs(func.args);
    }

    public void addNamedExpr(Expr.List list) throws Xcept {
        this.v.addNamedExpr(list);
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.expr(i).addNamedExpr(list);
        }
    }

    public void addDomains(Expr.List list) {
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.expr(i).addDomains(list);
        }
    }

    public boolean hasUnit() {
        return true;
    }

    public Unit unit() {
        return this.v.unit;
    }

    public Expr unitCorrect() throws Xcept {
        Expr.List nargs = new Expr.List(this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            Domain x = this.v.domain(i);
            Expr arg = this.args.expr(i).unitCorrect();
            Unit au = arg.unit();
            Unit xu = x.unit();
            if (!Unit.compatible((Unit)xu, (Unit)au)) {
                throw new Xcept((DiagInfo)this, "Units are not compatible with variable domain " + (Object)((Object)x));
            }
            nargs.add((Object)arg.multUnit(xu, au));
        }
        return new VarFuncCall(this.v, nargs);
    }

    public Expr expandDeriv() throws Xcept {
        Expr.List nargs = new Expr.List(this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            nargs.add((Object)this.args.expr(i).expandDeriv());
        }
        return new VarFuncCall(this.v, nargs);
    }

    public Expr takeDomDeriv(NamedExpr t) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDomDeriv not implemented");
    }

    public Expr linearFactor(NamedQueryExpr q, boolean keep) throws Xcept {
        if (keep) {
            return this.sameAs((Expr)q) ? one : zero;
        }
        return this.sameAs((Expr)q) ? zero : this;
    }

    public Expr calculable(Known known) throws Xcept {
        TypedSet s = known.getSet((NamedExpr)this.v);
        VectorExpr vec = VectorExpr.create((Expr.List)this.args);
        Expr ret = vec.in((Expr)s);
        for (int i = 0; i < this.v.ndim(); ++i) {
            Expr e1 = this.v.domain(i).calculable(known);
            ret = ret.and(e1);
        }
        return ret;
    }

    public Expr simplify(Known known) throws Xcept {
        Expr.List nargs = new Expr.List(this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            nargs.add((Object)this.args.expr(i).simplify(known));
        }
        return new VarFuncCall(this.v, nargs);
    }

    public String toString() {
        return this.v.toString() + this.args.toString();
    }

    public String toString(Context ctxt) {
        return ctxt.funcCall((Named)this.v, this.args);
    }
}

