/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.fzero;

import JSim.data.NamedVal;
import JSim.jruntime.RTContext;
import JSim.nml.Solver;
import JSim.nml.SolverCallbacks;
import JSim.util.Xcept;
import Jama.Matrix;

public class Fzero1Solver
extends Solver {
    private int n;

    public Fzero1Solver(SolverCallbacks cb, int inx, NamedVal.Query nvals, int nn) throws Xcept {
        super(cb, inx, nvals);
        this.n = nn;
    }

    public String solverName() {
        return "Linear zero finder";
    }

    public void solve(RTContext ctxt, double[] mat, double[] vec, double[] res) throws Xcept {
        double[][] vals = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                vals[i][j] = mat[i * this.n + j];
            }
        }
        Matrix A = new Matrix(vals);
        Matrix b = new Matrix(vec, this.n);
        Matrix x = A.solve(b.times(-1.0));
        for (int i = 0; i < this.n; ++i) {
            res[i] = x.get(i, 0);
        }
    }
}

