/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.math;

import JSim.util.Util;
import JSim.util.UtilMath;
import JSim.util.Xcept;

public class NatMath {
    private static long tstart;
    private static long tnative;
    private static long tjava;
    private static long n;
    private static double tot;
    private static double totNative;
    private static double totJava;

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan2(double var0, double var2);

    public static native double sinh(double var0);

    public static native double cosh(double var0);

    public static native double pow(double var0, double var2);

    public static native double sqrt(double var0);

    public static double pow(double a, int n) {
        switch (n) {
            case 1: {
                return a;
            }
            case 2: {
                return a * a;
            }
            case 3: {
                return a * a * a;
            }
            case 4: {
                return a * a * a * a;
            }
            case -1: {
                return 1.0 / a;
            }
            case -2: {
                return 1.0 / (a * a);
            }
            case -3: {
                return 1.0 / (a * a * a);
            }
            case -4: {
                return 1.0 / (a * a * a * a);
            }
        }
        return NatMath.pow(a, (double)n);
    }

    public static void main(String[] args) throws Xcept {
        if (args.length != 1) {
            throw new Xcept("Usage: NatMath ncalls");
        }
        n = Util.toInt((String)args[0]);
        System.out.println("NatMath profile ");
        System.out.println("ncalls=" + n);
        System.out.println("\tnative\tjava\t%perf\taccuracy");
        NatMath.startNative();
        int i = 0;
        while ((long)i < n) {
            tot += NatMath.sin((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.sin((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("sin");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.cos((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.cos((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("cos");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.tan((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.tan((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("tan");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.exp((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.exp((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("exp");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.log(1.0 + (double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.log(1.0 + (double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("log");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.log10(1.0 + (double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += UtilMath.log10((double)(1.0 + (double)i / ((double)n + 0.5)));
            ++i;
        }
        NatMath.print("log10");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.asin((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.asin((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("asin");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.acos((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.acos((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("acos");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.sinh((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += UtilMath.sinh((double)((double)i / ((double)n + 0.5)));
            ++i;
        }
        NatMath.print("sinh");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.cosh((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += UtilMath.cosh((double)((double)i / ((double)n + 0.5)));
            ++i;
        }
        NatMath.print("cosh");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.sqrt((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.sqrt((double)i / ((double)n + 0.5));
            ++i;
        }
        NatMath.print("sqrt");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.atan2((double)i / ((double)n + 0.5), 1.0);
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.atan2((double)i / ((double)n + 0.5), 1.0);
            ++i;
        }
        NatMath.print("atan2");
        NatMath.startNative();
        i = 0;
        while ((long)i < n) {
            tot += NatMath.pow((double)i / ((double)n + 0.5), 1.3);
            ++i;
        }
        NatMath.startJava();
        i = 0;
        while ((long)i < n) {
            tot += Math.pow((double)i / ((double)n + 0.5), 1.3);
            ++i;
        }
        NatMath.print("pow");
    }

    private static void startNative() {
        tstart = System.currentTimeMillis();
        tot = 0.0;
    }

    private static void startJava() {
        tnative = System.currentTimeMillis() - tstart;
        totNative = tot;
        tstart = System.currentTimeMillis();
        tot = 0.0;
    }

    private static void print(String name) {
        tjava = System.currentTimeMillis() - tstart;
        int pctDiff = (int)(100.0 * (double)(tjava - tnative) / (double)tjava);
        double totJava = tot;
        double acc = (totNative - totJava) / totJava;
        System.out.println(name + "\t" + tnative + "\t" + tjava + "\t" + pctDiff + "\t" + Util.pretty((double)acc));
    }

    static {
        System.loadLibrary("natmath");
    }
}

