/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.data.NamedVal;
import JSim.jruntime.RTContext;
import JSim.nml.Solver;
import JSim.nml.ode1.ODE1Callbacks;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1SolverAuto;
import JSim.nml.ode1.ODE1SolverCVode;
import JSim.nml.ode1.ODE1SolverDopri5;
import JSim.nml.ode1.ODE1SolverEuler;
import JSim.nml.ode1.ODE1SolverFehlberg;
import JSim.nml.ode1.ODE1SolverKM;
import JSim.nml.ode1.ODE1SolverRK2;
import JSim.nml.ode1.ODE1SolverRK4;
import JSim.nml.ode1.ODE1SolverRadau;
import JSim.util.Xcept;

public class ODE1Solver
extends Solver {
    private int n;
    private ODE1Slave slave;

    public ODE1Solver(ODE1Callbacks cb, int inx, NamedVal.Query nvals, int nn) throws Xcept {
        super(cb, inx, nvals);
        this.n = nn;
        int which = this.intVal("ode_which");
        this.slave = this.createSlave(which);
    }

    public ODE1Slave createSlave(int which) throws Xcept {
        switch (which) {
            case 0: {
                return new ODE1SolverAuto(this);
            }
            case 1: {
                return new ODE1SolverDopri5(this);
            }
            case 2: {
                return new ODE1SolverRadau(this);
            }
            case 3: {
                return new ODE1SolverKM(this);
            }
            case 4: {
                return new ODE1SolverFehlberg(this);
            }
            case 5: {
                return new ODE1SolverEuler(this);
            }
            case 6: {
                return new ODE1SolverRK2(this);
            }
            case 7: {
                return new ODE1SolverRK4(this);
            }
            case 8: {
                return new ODE1SolverCVode(this);
            }
        }
        throw new Xcept("Unknown ODE solver slave");
    }

    public void solve(RTContext ctxt, double t0, double tfinal, double[] u0, double[] uf) throws Xcept {
        if (this.slave == null) {
            throw new Xcept("ODE1Solver.solve() called without load()");
        }
        this.slave.solve(ctxt, t0, tfinal, u0, uf);
    }

    public String solverName() {
        if (this.slave == null) {
            return "unspecified ODE solver";
        }
        return this.slave.name() + " ODE solver";
    }

    public static native void allocNativeThreads(int var0);
}

