/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Callbacks;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public class ODE1SolverCVode
extends ODE1Slave {
    private double rtol = this.realVal("ode_CVode_reltol");
    private double atol = this.realVal("ode_CVode_abstol");
    private int maxsteps = this.intVal("ode_CVode_maxsteps");
    private boolean stiff = this.boolVal("ode_CVode_stiff");

    public ODE1SolverCVode(ODE1Solver s) throws Xcept {
        super(s, "cvode");
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int neqn = y0.length;
        double[] ydot = new double[neqn];
        for (int i = 0; i < neqn; ++i) {
            yend[i] = y0[i];
        }
        int idid = this.jcvode(ctxt.threadInx, ctxt, neqn, x0, xend, yend, ydot, this.rtol, this.atol, this.maxsteps, this.stiff, this.callbacks());
        if (idid < 0) {
            throw new Xcept("Solver Error: CVode - " + ODE1SolverCVode.status(idid));
        }
        this.callbacks().evaluate(ctxt, x0, y0, ydot);
    }

    public static String status(int idid) {
        switch (idid) {
            case -1: {
                return "cvode_mem argument is NULL";
            }
            case -2: {
                return "illegal input";
            }
            case -3: {
                return "too many internal steps";
            }
            case -4: {
                return "unable to satisfy user-specified accuracy";
            }
            case -5: {
                return "too many error test failures in time-step";
            }
            case -6: {
                return "too many convergence test failures in time-step";
            }
            case -7: {
                return "linear solver setup routine failed";
            }
            case -8: {
                return "linear solver solve routine failed";
            }
        }
        return "undocumented exit status=" + idid;
    }

    public native int jcvode(int var1, RTContext var2, int var3, double var4, double var6, double[] var8, double[] var9, double var10, double var12, int var14, boolean var15, ODE1Callbacks var16) throws Xcept;

    static {
        System.loadLibrary("odesolver");
    }
}

